/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddlutils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.JdbcModelReader;

public class JdbcModelReaderSupport
extends JdbcModelReader {
    public JdbcModelReaderSupport(Platform platform) {
        super(platform);
    }

    public void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck) throws SQLException {
        this.determineAutoIncrementFromResultSetMetaData(conn, table, columnsToCheck, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck, String catalogSeparator) throws SQLException {
        if (columnsToCheck == null || columnsToCheck.length == 0) {
            return;
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        for (int idx = 0; idx < columnsToCheck.length; ++idx) {
            if (idx > 0) {
                query.append(",");
            }
            query.append("t.");
            this.appendIdentifier(query, columnsToCheck[idx].getName());
        }
        query.append(" FROM ");
        if (table.getCatalog() != null && !table.getCatalog().trim().equals("")) {
            this.appendIdentifier(query, table.getCatalog());
            query.append(catalogSeparator);
        }
        if (table.getSchema() != null && !table.getSchema().trim().equals("")) {
            this.appendIdentifier(query, table.getSchema()).append(".");
        }
        this.appendIdentifier(query, table.getName()).append(" t WHERE 1 = 0");
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query.toString());
            ResultSetMetaData rsMetaData = rs.getMetaData();
            for (int idx = 0; idx < columnsToCheck.length; ++idx) {
                if (!rsMetaData.isAutoIncrement(idx + 1)) continue;
                columnsToCheck[idx].setAutoIncrement(true);
            }
            Object var11_11 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    public StringBuilder appendIdentifier(StringBuilder query, String identifier) {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(identifier);
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        return query;
    }
}

