/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;

public class SqLiteDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "@sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "@sync_node_disabled";

    protected void initTablesAndFunctionsForSpecificDialect() {
    }

    public String toFormattedTimestamp(Date time) {
        StringBuilder ts = new StringBuilder("datetime('");
        ts.append(JDBC_TIMESTAMP_FORMATTER.format(time));
        ts.append("')");
        return ts.toString();
    }

    public boolean supportsTransactionId() {
        return false;
    }

    private final String getTransactionFunctionName() {
        return null;
    }

    protected String getPlatformTableName(String catalogName, String schemaName, String tblName) {
        List tableNames = this.jdbcTemplate.queryForList("select distinct(tbl_name) from sqlite_master where tbl_name like '%" + tblName + "%'", String.class);
        if (tableNames.size() > 0) {
            return (String)tableNames.get(0);
        }
        return tblName;
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        catalog = catalog == null ? (this.getDefaultCatalog() == null ? null : this.getDefaultCatalog()) : catalog;
        String checkCatalogSql = catalog != null && catalog.length() > 0 ? " and trigger_schema='" + catalog + "'" : "";
        return this.jdbcTemplate.queryForInt("select count(*) from sqlite_master where type='trigger' and name like ? and tbl_name like ?" + checkCatalogSql, new Object[]{triggerName, tableName}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        catalogName = catalogName == null ? "" : catalogName + ".";
        String sql = "drop trigger " + catalogName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(sql);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    public void disableSyncTriggers(String nodeId) {
    }

    public void enableSyncTriggers() {
    }

    public String getSyncTriggersExpression() {
        return "@sync_triggers_disabled is null";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.getTransactionFunctionName() + "()";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select last_insert_id()";
    }

    public boolean isCharSpacePadded() {
        return false;
    }

    public boolean isCharSpaceTrimmed() {
        return true;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    protected String switchCatalogForTriggerInstall(String catalog, Connection c) throws SQLException {
        if (catalog != null) {
            String previousCatalog = c.getCatalog();
            c.setCatalog(catalog);
            return previousCatalog;
        }
        return null;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public String getIdentifierQuoteString() {
        return "";
    }
}

