/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.postgresql;

import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class PostgreSqlDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String TRANSACTION_ID_EXPRESSION = "txid_current()";
    static final String SYNC_TRIGGERS_DISABLED_VARIABLE = "symmetric.triggers_disabled";
    static final String SYNC_NODE_DISABLED_VARIABLE = "symmetric.node_disabled";
    private boolean supportsTransactionId = false;
    private String transactionIdExpression = "null";

    protected void initTablesAndFunctionsForSpecificDialect() {
        if (this.getMajorVersion() >= 8 && this.getMinorVersion() >= 3) {
            this.log.info("TransactionIDSupportEnabling");
            this.supportsTransactionId = true;
            this.transactionIdExpression = TRANSACTION_ID_EXPRESSION;
        }
        try {
            this.enableSyncTriggers();
        }
        catch (Exception e) {
            this.log.error("PostgreSqlCustomVariableMissing");
            throw new SymmetricException("PostgreSqlCustomVariableMissing", e);
        }
    }

    protected Integer overrideJdbcTypeForColumn(Map values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.equalsIgnoreCase("ABSTIME")) {
            return 93;
        }
        if (typeName != null && typeName.equalsIgnoreCase("OID")) {
            return 2004;
        }
        return super.overrideJdbcTypeForColumn(values);
    }

    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData) {
        Object[] objectValues = super.getObjectValues(encoding, values, orderedMetaData);
        for (int i = 0; i < orderedMetaData.length; ++i) {
            if (orderedMetaData[i] == null || orderedMetaData[i].getTypeCode() != 2004) continue;
            try {
                objectValues[i] = new SerialBlob((byte[])objectValues[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return objectValues;
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) from information_schema.triggers where trigger_name = ? and event_object_table = ? and trigger_schema = ?", new Object[]{triggerName.toLowerCase(), tableName.toLowerCase(), schema == null ? this.defaultSchema : schema}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        String dropSql = "drop trigger " + triggerName + " on " + schemaName + tableName;
        this.logSql(dropSql, sqlBuffer);
        String dropFunction = "drop function " + schemaName + "f" + triggerName + "()";
        this.logSql(dropFunction, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(dropSql);
                this.jdbcTemplate.update(dropFunction);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.queryForList("select set_config('symmetric.triggers_disabled', '1', false)");
        if (nodeId == null) {
            nodeId = "";
        }
        this.jdbcTemplate.queryForList("select set_config('symmetric.node_disabled', '" + nodeId + "', false)");
    }

    public void enableSyncTriggers() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                if (!transactionstatus.isRollbackOnly()) {
                    PostgreSqlDbDialect.this.jdbcTemplate.queryForList("select set_config('symmetric.triggers_disabled', '', false)");
                    PostgreSqlDbDialect.this.jdbcTemplate.queryForList("select set_config('symmetric.node_disabled', '', false)");
                }
            }
        });
    }

    public String getSyncTriggersExpression() {
        return "$(defaultSchema)" + this.tablePrefix + "_triggers_disabled() = 0";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.transactionIdExpression;
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select currval('" + sequenceName + "_seq')";
    }

    public boolean requiresSavepointForFallback() {
        return true;
    }

    public boolean isCharSpacePadded() {
        return true;
    }

    public boolean isCharSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean storesLowerCaseNamesInCatalog() {
        return true;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public boolean supportsTransactionId() {
        return this.supportsTransactionId;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((String)this.defaultSchema)) {
            this.defaultSchema = (String)this.jdbcTemplate.queryForObject("select current_schema()", String.class);
        }
        return super.getDefaultSchema();
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }
}

