/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.oracle;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class OracleDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String ORACLE_OBJECT_TYPE = "FUNCTION";
    String selectTriggerSql;
    String selectTransactionsSql;

    public void init(Platform pf) {
        block2: {
            super.init(pf);
            try {
                this.areDatabaseTransactionsPendingSince(System.currentTimeMillis());
                this.supportsTransactionViews = true;
            }
            catch (Exception ex) {
                if (!this.parameterService.is("oracle.use.transaction.view")) break block2;
                this.log.warn(ex);
            }
        }
    }

    protected void initLobHandler() {
        this.lobHandler = new OracleLobHandler();
        try {
            Class<?> clazz = Class.forName(this.parameterService.getString("db.native.extractor"));
            NativeJdbcExtractor nativeJdbcExtractor = (NativeJdbcExtractor)clazz.newInstance();
            ((OracleLobHandler)this.lobHandler).setNativeJdbcExtractor(nativeJdbcExtractor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Integer overrideJdbcTypeForColumn(Map values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("DATE")) {
            return 91;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP")) {
            return 93;
        }
        if (typeName != null && typeName.startsWith("NVARCHAR")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("NCHAR")) {
            return 1;
        }
        if (typeName != null && typeName.startsWith("BINARY_FLOAT")) {
            return 6;
        }
        if (typeName != null && typeName.startsWith("BINARY_DOUBLE")) {
            return 8;
        }
        return super.overrideJdbcTypeForColumn(values);
    }

    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory hist, String tablePrefix, Table table) {
        try {
            super.createTrigger(sqlBuffer, dml, trigger, hist, tablePrefix, table);
        }
        catch (BadSqlGrammarException ex) {
            if (ex.getSQLException().getErrorCode() == 4095) {
                try {
                    this.log.warn("TriggerAlreadyExists", this.jdbcTemplate.queryForMap("select * " + this.selectTriggerSql, new Object[]{hist.getTriggerNameForDmlType(dml), hist.getSourceTableName()}));
                }
                catch (DataAccessException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean isCharSpacePadded() {
        return true;
    }

    public boolean isCharSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return true;
    }

    public boolean isDateOverrideToTimestamp() {
        return true;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.tablePrefix + "_" + "transaction_id()";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    protected String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "SEQ_SYM_OUTGOIN_BATCH_BATCH_ID";
            }
            case DATA: {
                return "SEQ_SYM_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SEQ_SYM_TRIGGER_RIGGER_HIST_ID";
            }
        }
        return null;
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select " + sequenceName + ".currval from dual";
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) " + this.selectTriggerSql, new Object[]{triggerName, tableName}) > 0;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    public void purge() {
        this.jdbcTemplate.update("purge recyclebin");
    }

    protected String getSymmetricPackageName() {
        return this.tablePrefix + "_pkg";
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.update(String.format("call %s.setValue(1)", this.getSymmetricPackageName()));
        if (nodeId != null) {
            this.jdbcTemplate.update(String.format("call %s.setNodeValue('" + nodeId + "')", this.getSymmetricPackageName()));
        }
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.update(String.format("call %s.setValue(null)", this.getSymmetricPackageName()));
        this.jdbcTemplate.update(String.format("call %s.setNodeValue(null)", this.getSymmetricPackageName()));
    }

    public String getSyncTriggersExpression() {
        return this.tablePrefix + "_trigger_disabled() is null";
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((String)this.defaultSchema)) {
            this.defaultSchema = (String)this.jdbcTemplate.queryForObject("SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM dual", String.class);
        }
        return this.defaultSchema;
    }

    protected void initTablesAndFunctionsForSpecificDialect() {
    }

    public boolean areDatabaseTransactionsPendingSince(long time) {
        String returnValue = (String)this.jdbcTemplate.queryForObject(this.selectTransactionsSql, String.class);
        if (returnValue != null) {
            try {
                Date date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
                return date.getTime() < time;
            }
            catch (ParseException e) {
                this.log.error(e);
                return true;
            }
        }
        return false;
    }

    public void setSelectTransactionsSql(String selectTransactionSql) {
        this.selectTransactionsSql = selectTransactionSql;
    }

    public void setSelectTriggerSql(String selectTriggerSql) {
        this.selectTriggerSql = selectTriggerSql;
    }

    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews && this.parameterService.is("oracle.use.transaction.view");
    }

    public String massageDataExtractionSql(String sql, String channelId) {
        String channels = this.parameterService.getString("oracle.use.dbms.lob.substr.channels");
        if (!StringUtils.isBlank((String)channels) && channels.contains(channelId)) {
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)"dbms_lob.substr(d.row_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)"dbms_lob.substr(d.old_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)"dbms_lob.substr(d.pk_data, 4000, 1 )");
        }
        return sql;
    }
}

