/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;

public class MySqlDbDialect
extends AbstractDbDialect
implements IDbDialect {
    private static final String TRANSACTION_ID = "transaction_id";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "@sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "@sync_node_disabled";
    private String functionTemplateKeySuffix = null;

    protected void initTablesAndFunctionsForSpecificDialect() {
        int[] versions = Version.parseVersion(this.getProductVersion());
        this.functionTemplateKeySuffix = this.getMajorVersion() == 5 && (this.getMinorVersion() == 0 || this.getMinorVersion() == 1 && versions[2] < 23) ? "_pre_5_1_23" : "_post_5_1_23";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    protected void createRequiredFunctions() {
        String[] functions = this.sqlTemplate.getFunctionsToInstall();
        for (int i = 0; i < functions.length; ++i) {
            String funcName;
            if (!functions[i].endsWith(this.functionTemplateKeySuffix) || this.jdbcTemplate.queryForInt(this.sqlTemplate.getFunctionInstalledSql(funcName = this.tablePrefix + "_" + functions[i].substring(0, functions[i].length() - this.functionTemplateKeySuffix.length()), this.defaultSchema)) != 0) continue;
            this.jdbcTemplate.update(this.sqlTemplate.getFunctionSql(functions[i], funcName, this.defaultSchema));
            this.log.info("FunctionInstalled", funcName);
        }
    }

    protected String getPlatformTableName(String catalogName, String schemaName, String tblName) {
        List tableNames = this.jdbcTemplate.queryForList("select distinct(table_name) from information_schema.tables where table_name like '%" + tblName + "%'", String.class);
        if (tableNames.size() > 0) {
            return (String)tableNames.get(0);
        }
        return tblName;
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        catalog = catalog == null ? (this.getDefaultCatalog() == null ? null : this.getDefaultCatalog()) : catalog;
        String checkCatalogSql = catalog != null && catalog.length() > 0 ? " and trigger_schema='" + catalog + "'" : "";
        return this.jdbcTemplate.queryForInt("select count(*) from information_schema.triggers where trigger_name like ? and event_object_table like ?" + checkCatalogSql, new Object[]{triggerName, tableName}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        catalogName = catalogName == null ? "" : catalogName + ".";
        String sql = "drop trigger " + catalogName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(sql);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.update("set @sync_triggers_disabled=1");
        if (nodeId != null) {
            this.jdbcTemplate.update("set @sync_node_disabled='" + nodeId + "'");
        }
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.update("set @sync_triggers_disabled=null");
        this.jdbcTemplate.update("set @sync_node_disabled=null");
    }

    public String getSyncTriggersExpression() {
        return "@sync_triggers_disabled is null";
    }

    private final String getTransactionFunctionName() {
        return this.getDefaultCatalog() + "." + this.tablePrefix + "_" + TRANSACTION_ID;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.getTransactionFunctionName() + "()";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select last_insert_id()";
    }

    public boolean isCharSpacePadded() {
        return false;
    }

    public boolean isCharSpaceTrimmed() {
        return true;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return (String)this.jdbcTemplate.queryForObject("select database()", String.class);
    }

    protected String switchCatalogForTriggerInstall(String catalog, Connection c) throws SQLException {
        if (catalog != null) {
            String previousCatalog = c.getCatalog();
            c.setCatalog(catalog);
            return previousCatalog;
        }
        return null;
    }

    public int getStreamingResultsFetchSize() {
        return Integer.MIN_VALUE;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public String getIdentifierQuoteString() {
        return "`";
    }

    protected Integer overrideJdbcTypeForColumn(Map values) {
        String typeName = (String)values.get("TYPE_NAME");
        if ("YEAR".equals(typeName)) {
            return 4;
        }
        return super.overrideJdbcTypeForColumn(values);
    }
}

