/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hsqldb;

import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.db.AbstractEmbeddedDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;

public class HsqlDbDialect
extends AbstractEmbeddedDbDialect
implements IDbDialect {
    public static String DUAL_TABLE = "DUAL";
    private boolean enforceStrictSize = true;

    public void init(Platform pf) {
        super.init(pf);
        this.jdbcTemplate.update("SET WRITE_DELAY 100 MILLIS");
        this.jdbcTemplate.update("SET PROPERTY \"hsqldb.default_table_type\" 'cached'");
        this.jdbcTemplate.update("SET PROPERTY \"sql.enforce_strict_size\" " + this.enforceStrictSize);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                HsqlDbDialect.this.jdbcTemplate.update("SHUTDOWN");
            }
        });
        this.createDummyDualTable();
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists = this.jdbcTemplate.queryForInt("select count(*) from INFORMATION_SCHEMA.SYSTEM_TRIGGERS WHERE TRIGGER_NAME = ?", new Object[]{triggerName}) > 0 || this.jdbcTemplate.queryForInt("select count(*) from INFORMATION_SCHEMA.SYSTEM_TABLES WHERE TABLE_NAME = ?", new Object[]{String.format("%s_CONFIG", triggerName)}) > 0;
        return exists;
    }

    private void createDummyDualTable() {
        Table table = this.getTable(null, null, DUAL_TABLE, false);
        if (table == null) {
            this.jdbcTemplate.update("CREATE MEMORY TABLE " + DUAL_TABLE + "(DUMMY VARCHAR(1))");
            this.jdbcTemplate.update("INSERT INTO " + DUAL_TABLE + " VALUES(NULL)");
            this.jdbcTemplate.update("SET TABLE " + DUAL_TABLE + " READONLY TRUE");
        }
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        String dropSql = String.format("DROP TRIGGER %s", triggerName);
        this.logSql(dropSql, sqlBuffer);
        String dropTable = String.format("DROP TABLE IF EXISTS %s_CONFIG", triggerName);
        this.logSql(dropTable, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            int count;
            try {
                count = this.jdbcTemplate.update(dropSql);
                if (count > 0) {
                    this.log.info("TriggerDropped", triggerName);
                }
            }
            catch (Exception e) {
                this.log.warn("TriggerDropError", triggerName, e.getMessage());
            }
            try {
                count = this.jdbcTemplate.update(dropTable);
                if (count > 0) {
                    this.log.info("TableDropped", triggerName);
                }
            }
            catch (Exception e) {
                this.log.warn("TriggerDropError", triggerName, e.getMessage());
            }
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('sync_prevented','1')");
        this.jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('node_value','" + nodeId + "')");
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('sync_prevented',null)");
        this.jdbcTemplate.execute("CALL " + this.tablePrefix + "_set_session('node_value',null)");
    }

    public String getSyncTriggersExpression() {
        return " " + this.tablePrefix + "_get_session(''sync_prevented'') is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "call IDENTITY()";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean isCharSpacePadded() {
        return this.enforceStrictSize;
    }

    public boolean isCharSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }
}

