/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.h2;

import org.jumpmind.symmetric.db.AbstractEmbeddedDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;

public class H2DbDialect
extends AbstractEmbeddedDbDialect
implements IDbDialect {
    protected boolean doesTriggerExistOnPlatform(String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists;
        boolean bl = exists = this.jdbcTemplate.queryForInt("select count(*) from INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_NAME = ?", new Object[]{triggerName}) > 0 && this.jdbcTemplate.queryForInt("select count(*) from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = ?", new Object[]{String.format("%s_CONFIG", triggerName)}) > 0;
        if (!exists) {
            this.removeTrigger(new StringBuilder(), catalogName, schemaName, triggerName, tableName, null);
        }
        return exists;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        String dropSql = String.format("DROP TRIGGER IF EXISTS %s", triggerName);
        this.logSql(dropSql, sqlBuffer);
        String dropTable = String.format("DROP TABLE IF EXISTS %s_CONFIG", triggerName);
        this.logSql(dropTable, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                int count = this.jdbcTemplate.update(dropSql);
                if (count > 0) {
                    this.log.info("TriggerDropped", triggerName);
                }
                if ((count = this.jdbcTemplate.update(dropTable)) > 0) {
                    this.log.info("TableDropped", triggerName);
                }
            }
            catch (Exception e) {
                this.log.warn("TriggerDropError", triggerName, e.getMessage());
            }
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.update("set @sync_prevented=1");
        this.jdbcTemplate.update("set @node_value=?", new Object[]{nodeId});
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.update("set @sync_prevented=null");
        this.jdbcTemplate.update("set @node_value=null");
    }

    public String getSyncTriggersExpression() {
        return " @sync_prevented is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "TRANSACTION_ID()";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "call IDENTITY()";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean isCharSpacePadded() {
        return false;
    }

    public boolean isCharSpaceTrimmed() {
        return true;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }
}

