/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.derby;

import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;

public class DerbyDbDialect
extends AbstractDbDialect
implements IDbDialect {
    protected void initTablesAndFunctionsForSpecificDialect() {
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.getDefaultSchema() == null ? null : this.getDefaultSchema()) : schema;
        return this.jdbcTemplate.queryForInt("select count(*) from sys.systriggers where triggername = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.queryForInt(String.format("values %s_sync_triggers_set_disabled(1)", this.tablePrefix));
        if (nodeId != null) {
            this.jdbcTemplate.queryForObject(String.format("values %s_sync_node_set_disabled('%s')", this.tablePrefix, nodeId), String.class);
        }
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.queryForInt(String.format("values %s_sync_triggers_set_disabled(0)", this.tablePrefix));
        this.jdbcTemplate.queryForObject(String.format("values %s_sync_node_set_disabled(null)", this.tablePrefix), String.class);
    }

    public String getSyncTriggersExpression() {
        return String.format("%s_sync_triggers_disabled() = 0", this.tablePrefix);
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return String.format("%s_transaction_id()", this.tablePrefix);
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "values IDENTITY_VAL_LOCAL()";
    }

    public boolean isCharSpacePadded() {
        return true;
    }

    public boolean isCharSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((String)this.defaultSchema)) {
            this.defaultSchema = (String)this.jdbcTemplate.queryForObject("values CURRENT SCHEMA", String.class);
        }
        return this.defaultSchema;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }
}

