/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import java.net.URL;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.db.db2.Db2DbDialect;

public class Db2v9DbDialect
extends Db2DbDialect
implements IDbDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";

    protected void initTablesAndFunctionsForSpecificDialect() {
        try {
            this.enableSyncTriggers();
        }
        catch (Exception e) {
            try {
                this.log.info("EnvironmentVariablesCreating", SYNC_TRIGGERS_DISABLED_USER_VARIABLE, SYNC_TRIGGERS_DISABLED_NODE_VARIABLE);
                new SqlScript(this.getSqlScriptUrl(), this.getPlatform().getDataSource(), ";").execute();
            }
            catch (Exception ex) {
                this.log.error("DB2DialectInitializingError", ex);
            }
        }
    }

    private URL getSqlScriptUrl() {
        return this.getClass().getResource("/org/jumpmind/symmetric/db/db2.sql");
    }

    public void disableSyncTriggers(String nodeId) {
        this.jdbcTemplate.update("set sync_triggers_disabled=1");
        if (nodeId != null) {
            this.jdbcTemplate.update("set sync_node_disabled='" + nodeId + "'");
        }
    }

    public void enableSyncTriggers() {
        this.jdbcTemplate.update("set sync_triggers_disabled=null");
        this.jdbcTemplate.update("set sync_node_disabled=null");
    }

    public String getSyncTriggersExpression() {
        return "sync_triggers_disabled is null";
    }

    public String getSourceNodeExpression() {
        return SYNC_TRIGGERS_DISABLED_NODE_VARIABLE;
    }
}

