/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;

public class Db2DbDialect
extends AbstractDbDialect
implements IDbDialect {
    protected void initTablesAndFunctionsForSpecificDialect() {
    }

    protected boolean createTablesIfNecessary() {
        boolean tablesCreated = super.createTablesIfNecessary();
        if (tablesCreated) {
            long triggerHistId = this.jdbcTemplate.queryForLong("select max(trigger_hist_id) from " + this.tablePrefix + "_trigger_hist") + 1L;
            this.jdbcTemplate.update("alter table " + this.tablePrefix + "_trigger_hist alter column trigger_hist_id restart with " + triggerHistId);
            this.log.info("DB2ResettingAutoIncrementColumns", this.tablePrefix + "_trigger_hist");
            long outgoingBatchId = this.jdbcTemplate.queryForLong("select max(batch_id) from " + this.tablePrefix + "_outgoing_batch") + 1L;
            this.jdbcTemplate.update("alter table " + this.tablePrefix + "_outgoing_batch alter column batch_id restart with " + outgoingBatchId);
            this.log.info("DB2ResettingAutoIncrementColumns", this.tablePrefix + "_outgoing_batch");
            long dataId = this.jdbcTemplate.queryForLong("select max(data_id) from " + this.tablePrefix + "_data") + 1L;
            this.jdbcTemplate.update("alter table " + this.tablePrefix + "_data alter column data_id restart with " + dataId);
            this.log.info("DB2ResettingAutoIncrementColumns", this.tablePrefix + "_data");
        }
        return tablesCreated;
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.getDefaultSchema() == null ? null : this.getDefaultSchema()) : schema;
        return this.jdbcTemplate.queryForInt("select count(*) from syscat.triggers where trigname = ? and trigschema = ?", new Object[]{triggerName.toUpperCase(), schema.toUpperCase()}) > 0;
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public void disableSyncTriggers(String nodeId) {
    }

    public void enableSyncTriggers() {
    }

    public String getSyncTriggersExpression() {
        return "1=1";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "values IDENTITY_VAL_LOCAL()";
    }

    public boolean isCharSpacePadded() {
        return true;
    }

    public boolean isCharSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((String)this.defaultSchema)) {
            this.defaultSchema = (String)this.jdbcTemplate.queryForObject("values CURRENT SCHEMA", String.class);
        }
        return this.defaultSchema;
    }

    public String getIdentifierQuoteString() {
        return "";
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }
}

