/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlScript {
    static final String COMMENT_CHARS_1 = "--";
    static final String COMMENT_CHARS_2 = "#";
    static final ILog log = LogFactory.getLog(SqlScript.class);
    public static final String QUERY_ENDS = ";";
    private String delimiter = ";";
    private List<String> script;
    private DataSource dataSource;
    private int commitRate = 10000;
    private boolean failOnError = true;
    private Map<String, String> replacementTokens;
    private String fileName = "memory";

    public SqlScript(URL url, DataSource ds) {
        this(url, ds, true, QUERY_ENDS, null);
    }

    public SqlScript(URL url, DataSource ds, boolean failOnError) {
        this(url, ds, failOnError, QUERY_ENDS, null);
    }

    public SqlScript(URL url, DataSource ds, String delimiter) {
        this(url, ds, true, delimiter, null);
    }

    public SqlScript(URL url, DataSource ds, boolean failOnError, String delimiter, Map<String, String> replacementTokens) {
        try {
            this.fileName = url.getFile();
            this.fileName = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
            log.info("ScriptLoading", this.fileName);
            this.init(IOUtils.readLines((Reader)new InputStreamReader(url.openStream(), "UTF-8")), ds, failOnError, delimiter, replacementTokens);
        }
        catch (IOException ex) {
            log.error(ex);
            throw new RuntimeException(ex);
        }
    }

    public SqlScript(String sqlScript, DataSource ds, boolean failOnError, String delimiter, Map<String, String> replacementTokens) {
        try {
            this.init(IOUtils.readLines((Reader)new StringReader(sqlScript)), ds, failOnError, delimiter, replacementTokens);
        }
        catch (IOException ex) {
            log.error(ex);
            throw new RuntimeException(ex);
        }
    }

    private void init(List<String> sqlScript, DataSource ds, boolean failOnError, String delimiter, Map<String, String> replacementTokens) {
        this.script = sqlScript;
        this.dataSource = ds;
        this.failOnError = failOnError;
        this.delimiter = delimiter;
        this.replacementTokens = replacementTokens;
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    protected String replaceTokens(String original) {
        if (this.replacementTokens != null) {
            for (String key : this.replacementTokens.keySet()) {
                original = original.replaceAll("\\%" + key + "\\%", this.replacementTokens.get(key));
            }
        }
        return original;
    }

    public void execute() {
        this.execute(false);
    }

    public void execute(final boolean autoCommit) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                Statement st = null;
                int lineCount = 0;
                try {
                    block14: {
                        try {
                            connection.setAutoCommit(autoCommit);
                            st = connection.createStatement();
                            StringBuilder sql = new StringBuilder();
                            int count = 0;
                            int notFoundCount = 0;
                            for (String line : SqlScript.this.script) {
                                ++lineCount;
                                if ((line = SqlScript.this.trimComments(line)).trim().length() <= 0) continue;
                                if (SqlScript.this.checkStatementEnds(line)) {
                                    block13: {
                                        if (sql.length() > 0) {
                                            sql.append("\n");
                                        }
                                        sql.append(line.substring(0, line.lastIndexOf(SqlScript.this.delimiter)).trim());
                                        log.debug("Sql", sql);
                                        try {
                                            st.execute(SqlScript.this.replaceTokens(sql.toString()));
                                            if (++count % SqlScript.this.commitRate == 0) {
                                                connection.commit();
                                            }
                                        }
                                        catch (SQLException e) {
                                            if (SqlScript.this.failOnError) {
                                                log.error("SqlError", e, sql.toString());
                                                throw e;
                                            }
                                            if (e.getErrorCode() != 942 && e.getErrorCode() != 2289) {
                                                log.warn("Sql", e.getMessage() + ": " + sql.toString());
                                            }
                                            if (!sql.toString().toLowerCase().startsWith("drop")) break block13;
                                            ++notFoundCount;
                                        }
                                    }
                                    sql.setLength(0);
                                    continue;
                                }
                                sql.append("\n");
                                sql.append(line);
                            }
                            if (!autoCommit) {
                                connection.commit();
                            }
                            log.info("ScriptCompleted", count, SqlScript.this.fileName);
                            if (notFoundCount <= 0) break block14;
                            log.info("ScriptDropError", notFoundCount);
                        }
                        catch (Exception e) {
                            log.info("ScriptError", lineCount, SqlScript.this.fileName);
                            throw new RuntimeException(e);
                        }
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    SqlScript.this.closeQuietly(st);
                    throw throwable;
                }
                SqlScript.this.closeQuietly(st);
                return null;
            }
        });
    }

    private String trimComments(String line) {
        int index = line.indexOf(COMMENT_CHARS_1);
        if (index >= 0) {
            line = line.substring(0, index);
        }
        if ((index = line.indexOf(COMMENT_CHARS_2)) >= 0) {
            line = line.substring(0, index);
        }
        return line;
    }

    private boolean checkStatementEnds(String s) {
        return s.trim().endsWith("" + this.delimiter);
    }

    public int getCommitRate() {
        return this.commitRate;
    }

    public void setCommitRate(int commitRate) {
        this.commitRate = commitRate;
    }
}

