/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.Date;
import java.util.Set;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDbDialect {
    public void createTrigger(StringBuilder var1, DataEventType var2, Trigger var3, TriggerHistory var4, String var5, Table var6);

    public String getEngineName();

    public void removeTrigger(StringBuilder var1, String var2, String var3, String var4, String var5, TriggerHistory var6);

    public boolean doesTriggerExist(String var1, String var2, String var3, String var4);

    public void prepareTableForDataLoad(Table var1);

    public void cleanupAfterDataLoad(Table var1);

    public Database readPlatformDatabase(boolean var1);

    public void resetCachedTableModel();

    public boolean doesDatabaseNeedConfigured();

    public void initTablesAndFunctions();

    public Platform getPlatform();

    public String getName();

    public String getVersion();

    public int getMajorVersion();

    public int getMinorVersion();

    public String getProductVersion();

    public BinaryEncoding getBinaryEncoding();

    public Table getTable(String var1, String var2, String var3, boolean var4);

    public Table getTable(Trigger var1, boolean var2);

    public String getTransactionTriggerExpression(String var1, String var2, Trigger var3);

    public String createInitalLoadSqlFor(Node var1, TriggerRouter var2, Table var3);

    public String createPurgeSqlFor(Node var1, TriggerRouter var2);

    public String createCsvDataSql(Trigger var1, String var2);

    public String createCsvPrimaryKeySql(Trigger var1, String var2);

    public boolean isCharSpacePadded();

    public boolean isCharSpaceTrimmed();

    public boolean isEmptyStringNulled();

    public int getMaxTriggerNameLength();

    public boolean storesUpperCaseNamesInCatalog();

    public boolean storesLowerCaseNamesInCatalog();

    public boolean supportsTransactionId();

    public boolean supportsTransactionViews();

    public boolean requiresSavepointForFallback();

    public Object createSavepoint();

    public Object createSavepointForFallback();

    public void rollbackToSavepoint(Object var1);

    public void releaseSavepoint(Object var1);

    public IColumnFilter getDatabaseColumnFilter();

    public void purge();

    public SQLErrorCodeSQLExceptionTranslator getSqlErrorTranslator();

    public void disableSyncTriggers();

    public void disableSyncTriggers(String var1);

    public void enableSyncTriggers();

    public String getSyncTriggersExpression();

    public String getSourceNodeExpression();

    public String getDefaultSchema();

    public String getDefaultCatalog();

    public int getStreamingResultsFetchSize();

    public String getCreateSymmetricDDL();

    public String getCreateTableXML(TriggerRouter var1);

    public String getCreateTableSQL(TriggerRouter var1);

    public boolean isBlobSyncSupported();

    public boolean isDateOverrideToTimestamp();

    public boolean isClobSyncSupported();

    public boolean isTransactionIdOverrideSupported();

    public String getIdentifierQuoteString();

    public void createTables(String var1);

    public boolean supportsGetGeneratedKeys();

    public boolean supportsReturningKeys();

    public String getSelectLastInsertIdSql(String var1);

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2);

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2, PreparedStatementCallback<Object> var3);

    public long insertWithGeneratedKey(JdbcTemplate var1, String var2, SequenceIdentifier var3, PreparedStatementCallback<Object> var4);

    public Object[] getObjectValues(BinaryEncoding var1, String[] var2, Column[] var3);

    public Object[] getObjectValues(BinaryEncoding var1, Table var2, String[] var3, String[] var4);

    public String getTablePrefix();

    public int getRouterDataPeekAheadCount();

    public String replaceTemplateVariables(DataEventType var1, Trigger var2, TriggerHistory var3, String var4);

    public boolean supportsOpenCursorsAcrossCommit();

    public Set<String> getSqlKeywords();

    public String getInitialLoadTableAlias();

    public String preProcessTriggerSqlClause(String var1);

    public String toFormattedTimestamp(Date var1);

    public void truncateTable(String var1);

    public long getDatabaseTime();

    public boolean areDatabaseTransactionsPendingSince(long var1);

    public String massageDataExtractionSql(String var1, String var2);

    public LobHandler getLobHandler();
}

