/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.platform.db2.Db2Platform;
import org.apache.ddlutils.platform.derby.DerbyPlatform;
import org.apache.ddlutils.platform.hsqldb.HsqlDbPlatform;
import org.apache.ddlutils.platform.mssql.MSSqlPlatform;
import org.apache.ddlutils.platform.mysql.MySqlPlatform;
import org.apache.ddlutils.platform.oracle.Oracle10Platform;
import org.apache.ddlutils.platform.oracle.Oracle8Platform;
import org.apache.ddlutils.platform.oracle.Oracle9Platform;
import org.apache.ddlutils.platform.postgresql.PostgreSqlPlatform;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.DbNotSupportedException;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddlutils.PlatformFactory;
import org.jumpmind.symmetric.ddlutils.firebird.FirebirdPlatform;
import org.jumpmind.symmetric.ddlutils.h2.H2Platform;
import org.jumpmind.symmetric.ddlutils.sqlite.SqLitePlatform;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbDialectFactory
implements FactoryBean<IDbDialect>,
BeanFactoryAware {
    private static final ILog log = LogFactory.getLog(DbDialectFactory.class);
    private String db2zSeriesProductVersion;
    private JdbcTemplate jdbcTemplate;
    private BeanFactory beanFactory;

    public IDbDialect getObject() throws Exception {
        this.waitForAvailableDatabase();
        Platform pf = PlatformFactory.getPlatform(this.jdbcTemplate.getDataSource());
        AbstractDbDialect dialect = null;
        if (pf instanceof MySqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("mysqlDialect");
        } else if (pf instanceof Oracle8Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof Oracle9Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof Oracle10Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("oracleDialect");
        } else if (pf instanceof MSSqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("msSqlDialect");
        } else if (pf instanceof PostgreSqlPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("postgresqlDialect");
        } else if (pf instanceof DerbyPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("derbyDialect");
        } else if (pf instanceof H2Platform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("h2Dialect");
        } else if (pf instanceof SqLitePlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("sqliteDialect");
        } else if (pf instanceof HsqlDbPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("hsqldbDialect");
        } else if (pf instanceof Db2Platform) {
            String currentDbProductVersion = PlatformFactory.getDatabaseProductVersion(this.jdbcTemplate.getDataSource());
            dialect = currentDbProductVersion.equals(this.db2zSeriesProductVersion) ? (AbstractDbDialect)this.beanFactory.getBean("db2zSeriesDialect") : (PlatformFactory.getDbMajorVersion(this.jdbcTemplate.getDataSource()) < 9 || PlatformFactory.getDbMajorVersion(this.jdbcTemplate.getDataSource()) == 9 && PlatformFactory.getDbMinorVersion(this.jdbcTemplate.getDataSource()) < 5 ? (AbstractDbDialect)this.beanFactory.getBean("db2Dialect") : (AbstractDbDialect)this.beanFactory.getBean("db2v9Dialect"));
        } else if (pf instanceof FirebirdPlatform) {
            dialect = (AbstractDbDialect)this.beanFactory.getBean("firebirdDialect");
        } else {
            throw new DbNotSupportedException();
        }
        dialect.init(pf);
        dialect.setTransactionTemplate((TransactionTemplate)this.beanFactory.getBean("currentTransactionTemplate"));
        return dialect;
    }

    private void waitForAvailableDatabase() {
        boolean success = false;
        while (!success) {
            try {
                this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                    public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                        return null;
                    }
                });
                success = true;
            }
            catch (CannotGetJdbcConnectionException ex) {
                log.error("DatabaseConnectionException", ex.getMessage());
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Class<IDbDialect> getObjectType() {
        return IDbDialect.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setDb2zSeriesProductVersion(String version) {
        this.db2zSeriesProductVersion = version;
    }
}

