/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.HashMap;
import java.util.Map;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DatabaseModel
extends Database {
    private static final long serialVersionUID = 1L;
    private Map<String, Integer> tableIndexCache = new HashMap<String, Integer>();

    public Table findTable(String catalogName, String schemaName, String tableName, boolean caseSensitive) {
        Table table;
        String cacheKey = catalogName + "." + schemaName + "." + tableName + "." + caseSensitive;
        Integer tableIndex = this.tableIndexCache.get(cacheKey);
        if (tableIndex != null && tableIndex < this.getTableCount() && this.doesMatch(table = this.getTable(tableIndex), catalogName, schemaName, tableName, caseSensitive)) {
            return table;
        }
        Table[] tables = super.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table2 = tables[i];
            if (!this.doesMatch(table2, catalogName, schemaName, tableName, caseSensitive)) continue;
            this.tableIndexCache.put(cacheKey, i);
            return table2;
        }
        return null;
    }

    private boolean doesMatch(Table table, String catalogName, String schemaName, String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            return (catalogName == null || catalogName != null && catalogName.equals(table.getCatalog())) && (schemaName == null || schemaName != null && schemaName.equals(table.getSchema())) && table.getName().equals(tableName);
        }
        return (catalogName == null || catalogName != null && catalogName.equalsIgnoreCase(table.getCatalog())) && (schemaName == null || schemaName != null && schemaName.equalsIgnoreCase(table.getSchema())) && table.getName().equalsIgnoreCase(tableName);
    }

    public Table findTable(String catalogName, String schemaName, String tableName) {
        return this.findTable(catalogName, schemaName, tableName, false);
    }

    public void resetTableIndexCache() {
        this.tableIndexCache.clear();
    }
}

