/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.MetaDataColumnDescriptor;
import org.apache.ddlutils.platform.SqlBuilder;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.DatabaseModel;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.db.SqlTemplate;
import org.jumpmind.symmetric.db.mssql.MsSqlDbDialect;
import org.jumpmind.symmetric.ddlutils.JdbcModelReaderSupport;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDbDialect
implements IDbDialect {
    final ILog logger = LogFactory.getLog(this.getClass());
    public static final String REQUIRED_FIELD_NULL_SUBSTITUTE = " ";
    public static final String[] TIMESTAMP_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"};
    public static final String[] TIME_PATTERNS = new String[]{"HH:mm:ss.S", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss"};
    public static final FastDateFormat JDBC_TIMESTAMP_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd hh:mm:ss.SSS");
    protected final ILog log = LogFactory.getLog(this.getClass());
    public static final int MAX_SYMMETRIC_SUPPORTED_TRIGGER_SIZE = 50;
    protected JdbcTemplate jdbcTemplate;
    protected Platform platform;
    protected DatabaseModel cachedModel = new DatabaseModel();
    protected SqlTemplate sqlTemplate;
    protected SQLErrorCodeSQLExceptionTranslator sqlErrorTranslator;
    private Map<Integer, String> _defaultSizes = new HashMap<Integer, String>();
    protected IParameterService parameterService;
    protected String tablePrefix;
    protected int streamingResultsFetchSize;
    protected Boolean supportsGetGeneratedKeys;
    protected TransactionTemplate transactionTemplate;
    protected String databaseName;
    protected int databaseMajorVersion;
    protected int databaseMinorVersion;
    protected String databaseProductVersion;
    protected String identifierQuoteString;
    protected Set<String> sqlKeywords;
    protected String defaultSchema;
    protected LobHandler lobHandler;
    protected boolean supportsTransactionViews = false;

    protected AbstractDbDialect() {
        this._defaultSizes.put(new Integer(1), "254");
        this._defaultSizes.put(new Integer(12), "254");
        this._defaultSizes.put(new Integer(-1), "254");
        this._defaultSizes.put(new Integer(-2), "254");
        this._defaultSizes.put(new Integer(-3), "254");
        this._defaultSizes.put(new Integer(-4), "254");
        this._defaultSizes.put(new Integer(4), "32");
        this._defaultSizes.put(new Integer(-5), "64");
        this._defaultSizes.put(new Integer(7), "7,0");
        this._defaultSizes.put(new Integer(6), "15,0");
        this._defaultSizes.put(new Integer(8), "15,0");
        this._defaultSizes.put(new Integer(3), "15,15");
        this._defaultSizes.put(new Integer(2), "15,15");
    }

    @Override
    public String toFormattedTimestamp(java.util.Date time) {
        StringBuilder ts = new StringBuilder("{ts '");
        ts.append(JDBC_TIMESTAMP_FORMATTER.format(time));
        ts.append("'}");
        return ts.toString();
    }

    @Override
    public IColumnFilter getDatabaseColumnFilter() {
        return null;
    }

    @Override
    public void prepareTableForDataLoad(Table table) {
    }

    @Override
    public void cleanupAfterDataLoad(Table table) {
    }

    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCachedTableModel() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.cachedModel.resetTableIndexCache();
            Table[] tables = this.cachedModel.getTables();
            if (tables != null) {
                for (Table table : tables) {
                    this.cachedModel.removeTable(table);
                }
            }
        }
    }

    @Override
    public int getMaxTriggerNameLength() {
        int max = this.getPlatform().getPlatformInfo().getMaxColumnNameLength();
        return max < 50 && max > 0 ? max : 50;
    }

    public void init(Platform pf) {
        this.log.info("DbDialectInUse", this.getClass().getName());
        this.jdbcTemplate = new JdbcTemplate(pf.getDataSource());
        this.platform = pf;
        this.sqlErrorTranslator = new SQLErrorCodeSQLExceptionTranslator(pf.getDataSource());
        this.identifierQuoteString = "\"";
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData meta = c.getMetaData();
                AbstractDbDialect.this.databaseName = meta.getDatabaseProductName();
                AbstractDbDialect.this.databaseMajorVersion = meta.getDatabaseMajorVersion();
                AbstractDbDialect.this.databaseMinorVersion = meta.getDatabaseMinorVersion();
                AbstractDbDialect.this.databaseProductVersion = meta.getDatabaseProductVersion();
                return null;
            }
        });
    }

    protected abstract void initTablesAndFunctionsForSpecificDialect();

    @Override
    public void initTablesAndFunctions() {
        this.initTablesAndFunctionsForSpecificDialect();
        this.createTablesIfNecessary();
        this.createRequiredFunctions();
        this.resetCachedTableModel();
    }

    @Override
    public final boolean doesTriggerExist(String catalogName, String schema, String tableName, String triggerName) {
        try {
            return this.doesTriggerExistOnPlatform(catalogName, schema, tableName, triggerName);
        }
        catch (Exception ex) {
            this.log.warn("TriggerMayExist", ex);
            return false;
        }
    }

    protected void createRequiredFunctions() {
        String[] functions = this.sqlTemplate.getFunctionsToInstall();
        for (int i = 0; i < functions.length; ++i) {
            String funcName = this.tablePrefix + "_" + functions[i];
            if (this.jdbcTemplate.queryForInt(this.sqlTemplate.getFunctionInstalledSql(funcName, this.defaultSchema)) != 0) continue;
            this.jdbcTemplate.update(this.sqlTemplate.getFunctionSql(functions[i], funcName, this.defaultSchema));
            this.log.info("FunctionInstalled", funcName);
        }
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.NONE;
    }

    @Override
    public boolean isDateOverrideToTimestamp() {
        return false;
    }

    protected abstract boolean doesTriggerExistOnPlatform(String var1, String var2, String var3, String var4);

    @Override
    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    @Override
    public String createInitalLoadSqlFor(Node node, TriggerRouter trigger, Table table) {
        return this.sqlTemplate.createInitalLoadSql(node, this, trigger, table).trim();
    }

    @Override
    public String createPurgeSqlFor(Node node, TriggerRouter triggerRouter) {
        return this.sqlTemplate.createPurgeSql(node, this, triggerRouter);
    }

    @Override
    public String createCsvDataSql(Trigger trigger, String whereClause) {
        return this.sqlTemplate.createCsvDataSql(this, trigger, this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), true), whereClause).trim();
    }

    @Override
    public String createCsvPrimaryKeySql(Trigger trigger, String whereClause) {
        return this.sqlTemplate.createCsvPrimaryKeySql(this, trigger, this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), true), whereClause).trim();
    }

    @Override
    public Table getTable(Trigger trigger, boolean useCache) {
        return this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String catalogName, String schemaName, String tableName, boolean useCache) {
        Table retTable = this.cachedModel.findTable(catalogName, schemaName, tableName);
        if (retTable == null || !useCache) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    Table table = this.getTable(catalogName, schemaName, tableName);
                    if (retTable != null) {
                        this.cachedModel.removeTable(retTable);
                    }
                    if (table != null) {
                        this.cachedModel.addTable(table);
                    }
                    retTable = table;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return retTable;
    }

    @Override
    public Set<String> getSqlKeywords() {
        if (this.sqlKeywords == null) {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    DatabaseMetaData metaData = con.getMetaData();
                    AbstractDbDialect.this.sqlKeywords = new HashSet<String>(Arrays.asList(metaData.getSQLKeywords().split(",")));
                    return null;
                }
            });
        }
        return this.sqlKeywords;
    }

    protected Table getTable(String catalogName, String schemaName, String tblName) {
        if (this.parameterService.is("db.metadata.ignore.case")) {
            Table table = this.getTableCaseSensitive(StringUtils.upperCase((String)catalogName), StringUtils.upperCase((String)schemaName), StringUtils.upperCase((String)tblName));
            if (table == null && (table = this.getTableCaseSensitive(StringUtils.lowerCase((String)catalogName), StringUtils.lowerCase((String)schemaName), StringUtils.lowerCase((String)tblName))) == null && (table = this.getTableCaseSensitive(catalogName, schemaName, StringUtils.upperCase((String)tblName))) == null && (table = this.getTableCaseSensitive(catalogName, schemaName, StringUtils.lowerCase((String)tblName))) == null) {
                table = this.getTableCaseSensitive(catalogName, schemaName, this.getPlatformTableName(catalogName, schemaName, tblName));
            }
            return table;
        }
        return this.getTableCaseSensitive(catalogName, schemaName, tblName);
    }

    protected String getPlatformTableName(String catalogName, String schemaName, String tblName) {
        return tblName;
    }

    protected Table getTableCaseSensitive(String catalogName, String schemaName, final String tblName) {
        final String schema = StringUtils.isBlank((String)schemaName) ? this.getDefaultSchema() : schemaName;
        final String catalog = StringUtils.isBlank((String)catalogName) ? this.getDefaultCatalog() : catalogName;
        return (Table)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Table>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Table doInConnection(Connection c) throws SQLException, DataAccessException {
                Table table = null;
                DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
                metaData.setMetaData(c.getMetaData());
                metaData.setCatalog(catalog);
                metaData.setSchemaPattern(schema);
                metaData.setTableTypes(null);
                String tableName = tblName;
                if (AbstractDbDialect.this.storesUpperCaseNamesInCatalog()) {
                    tableName = tblName.toUpperCase();
                } else if (AbstractDbDialect.this.storesLowerCaseNamesInCatalog()) {
                    tableName = tblName.toLowerCase();
                }
                ResultSet tableData = null;
                try {
                    tableData = metaData.getTables(AbstractDbDialect.this.getTableNamePattern(tableName));
                    while (tableData != null && tableData.next()) {
                        Map<String, Object> values = AbstractDbDialect.this.readColumns(tableData, AbstractDbDialect.this.initColumnsForTable());
                        table = AbstractDbDialect.this.readTable(metaData, values);
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(tableData);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)tableData);
                AbstractDbDialect.this.makeAllColumnsPrimaryKeysIfNoPrimaryKeysFound(table);
                return table;
            }
        });
    }

    protected String getTableNamePattern(String tableName) {
        return tableName;
    }

    protected void makeAllColumnsPrimaryKeysIfNoPrimaryKeysFound(Table table) {
        if (table != null && table.getPrimaryKeyColumns() != null && table.getPrimaryKeyColumns().length == 0) {
            Column[] allCoumns;
            for (Column column : allCoumns = table.getColumns()) {
                if (column.isOfBinaryType()) continue;
                column.setPrimaryKey(true);
            }
        }
    }

    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        Table table = null;
        if (tableName != null && tableName.length() > 0) {
            table = new Table();
            table.setName(tableName);
            table.setType((String)values.get("TABLE_TYPE"));
            table.setCatalog((String)values.get("TABLE_CAT"));
            table.setSchema((String)values.get("TABLE_SCHEM"));
            table.setDescription((String)values.get("REMARKS"));
            table.addColumns(this.readColumns(metaData, tableName));
            if (this.parameterService.is("initial.load.create.first")) {
                table.addIndices(this.readIndices(metaData, tableName));
            }
            Collection<String> primaryKeys = this.readPrimaryKeyNames(metaData, tableName);
            Iterator<String> it = primaryKeys.iterator();
            while (it.hasNext()) {
                table.findColumn(it.next(), true).setPrimaryKey(true);
            }
            if (this instanceof MsSqlDbDialect) {
                this.determineAutoIncrementFromResultSetMetaData(table, table.getColumns());
            }
        }
        return table;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForTable() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_TYPE", 12, (Object)"UNKNOWN"));
        result.add(new MetaDataColumnDescriptor("TABLE_CAT", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_SCHEM", 12));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForColumn() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_DEF", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TYPE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("DATA_TYPE", 4, (Object)new Integer(1111)));
        result.add(new MetaDataColumnDescriptor("NUM_PREC_RADIX", 4, (Object)new Integer(10)));
        result.add(new MetaDataColumnDescriptor("DECIMAL_DIGITS", 4, (Object)new Integer(0)));
        result.add(new MetaDataColumnDescriptor("COLUMN_SIZE", 12));
        result.add(new MetaDataColumnDescriptor("IS_NULLABLE", 12, (Object)"YES"));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForPK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("PK_NAME", 12));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Column> readColumns(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<Column> arrayList;
        ResultSet columnData = null;
        try {
            columnData = metaData.getColumns(this.getTableNamePattern(tableName), null);
            ArrayList<Column> columns = new ArrayList<Column>();
            Map<String, Object> values = null;
            while (columnData.next()) {
                values = this.readColumns(columnData, this.initColumnsForColumn());
                columns.add(this.readColumn(metaData, values));
            }
            arrayList = columns;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(columnData);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)columnData);
        return arrayList;
    }

    protected Integer overrideJdbcTypeForColumn(Map values) {
        return null;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = new Column();
        column.setName((String)values.get("COLUMN_NAME"));
        column.setDefaultValue((String)values.get("COLUMN_DEF"));
        Integer jdbcType = this.overrideJdbcTypeForColumn(values);
        if (jdbcType != null) {
            column.setTypeCode(jdbcType.intValue());
        } else {
            column.setTypeCode(((Integer)values.get("DATA_TYPE")).intValue());
        }
        column.setPrecisionRadix(((Integer)values.get("NUM_PREC_RADIX")).intValue());
        String size = (String)values.get("COLUMN_SIZE");
        int scale = (Integer)values.get("DECIMAL_DIGITS");
        if (size == null) {
            size = this._defaultSizes.get(new Integer(column.getTypeCode()));
        }
        column.setSize(size);
        if (scale != 0) {
            column.setScale(scale);
        }
        column.setRequired("NO".equalsIgnoreCase(((String)values.get("IS_NULLABLE")).trim()));
        column.setDescription((String)values.get("REMARKS"));
        return column;
    }

    protected void determineAutoIncrementFromResultSetMetaData(final Table table, final Column[] columnsToCheck) throws SQLException {
        final JdbcModelReaderSupport reader = new JdbcModelReaderSupport(this.platform);
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection conn) throws SQLException, DataAccessException {
                reader.determineAutoIncrementFromResultSetMetaData(conn, table, columnsToCheck);
                return null;
            }
        });
    }

    protected Map<String, Object> readColumns(ResultSet resultSet, List columnDescriptors) throws SQLException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (MetaDataColumnDescriptor descriptor : columnDescriptors) {
            values.put(descriptor.getName(), descriptor.readColumn(resultSet));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> readPrimaryKeyNames(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet pkData = null;
        try {
            ArrayList<String> pks = new ArrayList<String>();
            pkData = metaData.getPrimaryKeys(this.getTableNamePattern(tableName));
            while (pkData.next()) {
                Map<String, Object> values = this.readColumns(pkData, this.initColumnsForPK());
                pks.add(this.readPrimaryKeyName(metaData, values));
            }
            arrayList = pks;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(pkData);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)pkData);
        return arrayList;
    }

    protected String readPrimaryKeyName(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        return (String)values.get("COLUMN_NAME");
    }

    protected List initColumnsForIndex() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("INDEX_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("NON_UNIQUE", -7, (Object)Boolean.TRUE));
        result.add(new MetaDataColumnDescriptor("ORDINAL_POSITION", -6, (Object)new Short(0)));
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TYPE", -6));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection readIndices(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ListOrderedMap indices = new ListOrderedMap();
        ResultSet indexData = null;
        try {
            indexData = metaData.getIndices(this.getTableNamePattern(tableName), false, false);
            while (indexData.next()) {
                Map<String, Object> values = this.readColumns(indexData, this.initColumnsForIndex());
                this.readIndex(metaData, values, (Map)indices);
            }
        }
        finally {
            if (indexData != null) {
                indexData.close();
            }
        }
        return indices.values();
    }

    protected void readIndex(DatabaseMetaDataWrapper metaData, Map values, Map knownIndices) throws SQLException {
        Short indexType = (Short)values.get("TYPE");
        if (indexType != null && indexType == 0) {
            return;
        }
        String indexName = (String)values.get("INDEX_NAME");
        if (indexName != null) {
            Object index = (Index)knownIndices.get(indexName);
            if (index == null) {
                index = (Boolean)values.get("NON_UNIQUE") != false ? new NonUniqueIndex() : new UniqueIndex();
                index.setName(indexName);
                knownIndices.put(indexName, index);
            }
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.setName((String)values.get("COLUMN_NAME"));
            if (values.containsKey("ORDINAL_POSITION")) {
                indexColumn.setOrdinalPosition(((Short)values.get("ORDINAL_POSITION")).intValue());
            }
            index.addColumn(indexColumn);
        }
    }

    @Override
    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        String sql = "drop trigger " + schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(sql);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    protected final void logSql(String sql, StringBuilder sqlBuffer) {
        if (sqlBuffer != null) {
            sqlBuffer.append(sql);
            sqlBuffer.append(System.getProperty("line.separator"));
            sqlBuffer.append(System.getProperty("line.separator"));
        }
    }

    @Override
    public void createTrigger(final StringBuilder sqlBuffer, final DataEventType dml, final Trigger trigger, final TriggerHistory hist, final String tablePrefix, final Table table) {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                AbstractDbDialect.this.log.info("TriggerCreating", hist.getTriggerNameForDmlType(dml), trigger.getSourceTableName());
                String previousCatalog = null;
                String sourceCatalogName = trigger.getSourceCatalogName();
                String defaultCatalog = AbstractDbDialect.this.getDefaultCatalog();
                String defaultSchema = AbstractDbDialect.this.getDefaultSchema();
                try {
                    previousCatalog = AbstractDbDialect.this.switchCatalogForTriggerInstall(sourceCatalogName, con);
                    String triggerSql = AbstractDbDialect.this.sqlTemplate.createTriggerDDL(AbstractDbDialect.this, dml, trigger, hist, tablePrefix, table, defaultCatalog, defaultSchema);
                    if (AbstractDbDialect.this.parameterService.is("auto.sync.triggers")) {
                        Statement stmt = con.createStatement();
                        stmt.setQueryTimeout(AbstractDbDialect.this.jdbcTemplate.getQueryTimeout());
                        try {
                            AbstractDbDialect.this.log.debug("Sql", triggerSql);
                            stmt.executeUpdate(triggerSql);
                        }
                        catch (SQLException ex) {
                            AbstractDbDialect.this.log.error("TriggerCreateFailed", triggerSql);
                            throw ex;
                        }
                        String postTriggerDml = AbstractDbDialect.this.createPostTriggerDDL(dml, trigger, hist, tablePrefix, table);
                        if (postTriggerDml != null) {
                            try {
                                stmt.executeUpdate(postTriggerDml);
                            }
                            catch (SQLException ex) {
                                AbstractDbDialect.this.log.error("PostTriggerCreateFailed", postTriggerDml);
                                throw ex;
                            }
                        }
                        stmt.close();
                    }
                    AbstractDbDialect.this.logSql(triggerSql, sqlBuffer);
                }
                finally {
                    if (sourceCatalogName != null && !sourceCatalogName.equalsIgnoreCase(previousCatalog)) {
                        AbstractDbDialect.this.switchCatalogForTriggerInstall(previousCatalog, con);
                    }
                }
                return null;
            }
        });
    }

    protected String switchCatalogForTriggerInstall(String catalog, Connection c) throws SQLException {
        return null;
    }

    public String createPostTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory hist, String tablePrefix, Table table) {
        return this.sqlTemplate.createPostTriggerDDL(this, dml, trigger, hist, tablePrefix, table, this.getDefaultCatalog(), this.getDefaultSchema());
    }

    @Override
    public String getCreateSymmetricDDL() {
        Database db = this.readSymmetricSchemaFromXml();
        this.prefixConfigDatabase(db);
        return this.platform.getCreateTablesSql(db, true, true);
    }

    @Override
    public String getCreateTableSQL(TriggerRouter trig) {
        Table table = this.getTable(null, trig.getTrigger().getSourceSchemaName(), trig.getTrigger().getSourceTableName(), true);
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.platform.getSqlBuilder().setWriter((Writer)buffer);
            this.platform.getSqlBuilder().createTable((Database)this.cachedModel, table);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    @Override
    public String getCreateTableXML(TriggerRouter triggerRouter) {
        Table table = this.getTable(null, triggerRouter.getTrigger().getSourceSchemaName(), triggerRouter.getTrigger().getSourceTableName());
        table.setName(triggerRouter.getTargetTable());
        Database db = new Database();
        db.setName(triggerRouter.getTargetSchema(this.getDefaultSchema()));
        if (db.getName() == null) {
            db.setName(this.getDefaultCatalog());
        }
        db.addTable(table);
        StringWriter buffer = new StringWriter();
        DatabaseIO xmlWriter = new DatabaseIO();
        xmlWriter.write(db, (Writer)buffer);
        String xml = buffer.toString().replaceAll("&apos;", "");
        xml = xml.replaceAll("default=\"empty_blob\\(\\) *\"", "");
        xml = xml.replaceAll("unique name=\"PRIMARY\"", "unique name=\"PRIMARYINDEX\"");
        return xml;
    }

    @Override
    public void createTables(String xml) {
        StringReader reader = new StringReader(xml);
        Database db = new DatabaseIO().read((Reader)reader);
        this.platform.createTables(db, true, true);
    }

    @Override
    public boolean doesDatabaseNeedConfigured() {
        return this.prefixConfigDatabase(this.readSymmetricSchemaFromXml());
    }

    protected boolean prefixConfigDatabase(Database targetTables) {
        try {
            String tblPrefix = this.tablePrefix + "_";
            Table[] tables = targetTables.getTables();
            boolean createTables = false;
            for (Table table : tables) {
                table.setName(tblPrefix + table.getName());
                this.fixForeignKeys(table, tblPrefix, false);
                if (this.getTable(this.getDefaultCatalog(), this.getDefaultSchema(), table.getName(), false) != null) continue;
                createTables = true;
            }
            return createTables;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Database readPlatformDatabase(boolean includeSymmetricTables) {
        String schema = this.getDefaultSchema();
        String catalog = this.getDefaultCatalog();
        Database database = this.platform.readModelFromDatabase(!StringUtils.isBlank((String)schema) ? schema : (!StringUtils.isBlank((String)catalog) ? catalog : "database"), catalog, schema, null);
        if (!includeSymmetricTables) {
            Table[] allTables;
            Table[] tables;
            Database symmetricTables = this.readSymmetricSchemaFromXml();
            for (Table symTable : tables = symmetricTables.getTables()) {
                for (Table table : database.getTables()) {
                    if (!table.getName().equalsIgnoreCase(symTable.getName())) continue;
                    database.removeTable(table);
                }
            }
            for (Table table : allTables = database.getTables()) {
                if (!table.getName().startsWith(this.tablePrefix.toUpperCase() + "_ON_")) continue;
                database.removeTable(table);
            }
        }
        return database;
    }

    protected boolean createTablesIfNecessary() {
        Database symmetricTables = this.readSymmetricSchemaFromXml();
        try {
            this.log.info("TablesAutoUpdatingStart");
            String alterSql = this.getAlterSql(symmetricTables);
            if (!StringUtils.isBlank((String)alterSql)) {
                new SqlScript(alterSql, this.jdbcTemplate.getDataSource(), true, this.platform.getPlatformInfo().getSqlCommandDelimiter(), null).execute();
                return true;
            }
            return false;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String getAlterSql(Database desiredModel) throws IOException {
        Database currentModel = new Database();
        Table[] tables = desiredModel.getTables();
        Database existingModel = this.readPlatformDatabase(true);
        for (Table table : tables) {
            Table currentVersion = existingModel.findTable(table.getName());
            if (currentVersion == null) continue;
            currentModel.addTable(currentVersion);
        }
        SqlBuilder builder = this.platform.getSqlBuilder();
        StringWriter writer = new StringWriter();
        builder.setWriter((Writer)writer);
        builder.alterDatabase(currentModel, desiredModel, null);
        return writer.toString();
    }

    protected Database readSymmetricSchemaFromXml() {
        try {
            Database database = new DatabaseIO().read((Reader)new InputStreamReader(AbstractDbDialect.class.getResource("/symmetric-schema.xml").openStream()));
            if (this.prefixConfigDatabase(database)) {
                this.log.info("TablesMissing");
            }
            return database;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void fixForeignKeys(Table table, String tablePrefix, boolean clone) throws CloneNotSupportedException {
        ForeignKey[] keys;
        for (ForeignKey key : keys = table.getForeignKeys()) {
            if (clone) {
                table.removeForeignKey(key);
                key = (ForeignKey)key.clone();
                table.addForeignKey(key);
            }
            String prefixedName = tablePrefix + key.getForeignTableName();
            key.setForeignTableName(prefixedName);
            key.setName(tablePrefix + key.getName());
        }
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public String getName() {
        return this.databaseName;
    }

    @Override
    public String getVersion() {
        return this.databaseMajorVersion + "." + this.databaseMinorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public String getProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, String targetString) {
        return this.sqlTemplate.replaceTemplateVariables(this, dml, trigger, history, this.tablePrefix, this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), true), this.getDefaultCatalog(), this.getDefaultSchema(), targetString);
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        if (this.supportsGetGeneratedKeys == null) {
            this.supportsGetGeneratedKeys = (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

                public Boolean doInConnection(Connection conn) throws SQLException, DataAccessException {
                    return conn.getMetaData().supportsGetGeneratedKeys();
                }
            });
        }
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews;
    }

    @Override
    public boolean supportsReturningKeys() {
        return false;
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier sequenceId) {
        return this.insertWithGeneratedKey(this.jdbcTemplate, sql, sequenceId, null);
    }

    protected String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "sym_outgoing_batch_batch_id";
            }
            case DATA: {
                return "sym_data_data_id";
            }
            case TRIGGER_HIST: {
                return "sym_trigger_his_ger_hist_id";
            }
        }
        return null;
    }

    protected String getSequenceKeyName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "batch_id";
            }
            case DATA: {
                return "data_id";
            }
            case TRIGGER_HIST: {
                return "trigger_hist_id";
            }
        }
        return null;
    }

    protected Column[] orderColumns(String[] columnNames, Table table) {
        Column[] unorderedColumns = table.getColumns();
        Column[] orderedColumns = new Column[columnNames.length];
        block0: for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            for (Column column : unorderedColumns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                orderedColumns[i] = column;
                continue block0;
            }
        }
        return orderedColumns;
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, Table table, String[] columnNames, String[] values) {
        Column[] metaData = this.orderColumns(columnNames, table);
        return this.getObjectValues(encoding, values, metaData);
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            Object objectValue = value;
            Column column = orderedMetaData[i];
            try {
                if (column == null) continue;
                int type = column.getTypeCode();
                if ((value == null || this.isEmptyStringNulled() && value.equals("")) && column.isRequired() && column.isOfTextType()) {
                    objectValue = REQUIRED_FIELD_NULL_SUBSTITUTE;
                }
                if (value != null) {
                    if (type == 91 && !this.isDateOverrideToTimestamp()) {
                        objectValue = new Date(this.getTime(value, TIMESTAMP_PATTERNS));
                    } else if (type == 93 || type == 91 && this.isDateOverrideToTimestamp()) {
                        objectValue = new Timestamp(this.getTime(value, TIMESTAMP_PATTERNS));
                    } else if (type == 1 && this.isCharSpacePadded()) {
                        objectValue = StringUtils.rightPad((String)value.toString(), (int)column.getSizeAsInt(), (char)' ');
                    } else if (type == 4 || type == 5 || type == -7) {
                        objectValue = Integer.valueOf(value);
                    } else if (type == 2 || type == 3 || type == 6 || type == 8) {
                        objectValue = new BigDecimal(value.replace(',', '.'));
                    } else if (type == 16) {
                        objectValue = value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
                    } else if (type == 2004 || type == -4 || type == -2 || type == -3) {
                        if (encoding == BinaryEncoding.NONE) {
                            objectValue = value.getBytes();
                        } else if (encoding == BinaryEncoding.BASE64) {
                            objectValue = Base64.decodeBase64((byte[])value.getBytes());
                        } else if (encoding == BinaryEncoding.HEX) {
                            objectValue = Hex.decodeHex((char[])value.toCharArray());
                        }
                    } else if (type == 92) {
                        objectValue = new Time(this.getTime(value, TIME_PATTERNS));
                    }
                }
                list.add((String)objectValue);
                continue;
            }
            catch (Exception ex) {
                this.logger.error("DbDialectTroubleConvertingColumnValue", value, column.getName(), column.getType());
                throw new RuntimeException(ex);
            }
        }
        return list.toArray();
    }

    private long getTime(String value, String[] pattern) {
        try {
            return DateUtils.parseDate((String)value, (String[])pattern).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier sequenceId, PreparedStatementCallback<Object> callback) {
        return this.insertWithGeneratedKey(this.jdbcTemplate, sql, sequenceId, callback);
    }

    @Override
    public long insertWithGeneratedKey(final JdbcTemplate template, final String sql, final SequenceIdentifier sequenceId, final PreparedStatementCallback<Object> callback) {
        return (Long)template.execute((ConnectionCallback)new ConnectionCallback<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long doInConnection(Connection conn) throws SQLException, DataAccessException {
                PreparedStatement ps;
                long key;
                block19: {
                    key = 0L;
                    ps = null;
                    try {
                        boolean supportsGetGeneratedKeys = AbstractDbDialect.this.supportsGetGeneratedKeys();
                        boolean supportsReturningKeys = AbstractDbDialect.this.supportsReturningKeys();
                        if (AbstractDbDialect.this.allowsNullForIdentityColumn()) {
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(sql, new int[]{1}) : (supportsReturningKeys ? conn.prepareStatement(sql + " returning " + AbstractDbDialect.this.getSequenceKeyName(sequenceId)) : conn.prepareStatement(sql));
                        } else {
                            String replaceSql = sql.replaceFirst("\\(\\w*,", "(").replaceFirst("\\(null,", "(");
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(replaceSql, 1) : conn.prepareStatement(replaceSql);
                        }
                        ps.setQueryTimeout(template.getQueryTimeout());
                        if (callback != null) {
                            callback.doInPreparedStatement(ps);
                        }
                        ResultSet rs = null;
                        if (supportsGetGeneratedKeys) {
                            ps.executeUpdate();
                            try {
                                rs = ps.getGeneratedKeys();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                break block19;
                            }
                            finally {
                                JdbcUtils.closeResultSet((ResultSet)rs);
                            }
                        }
                        if (supportsReturningKeys) {
                            try {
                                rs = ps.executeQuery();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                break block19;
                            }
                            finally {
                                JdbcUtils.closeResultSet((ResultSet)rs);
                            }
                        }
                        Statement st = null;
                        ps.executeUpdate();
                        try {
                            st = conn.createStatement();
                            rs = st.executeQuery(AbstractDbDialect.this.getSelectLastInsertIdSql(AbstractDbDialect.this.getSequenceName(sequenceId)));
                            if (rs.next()) {
                                key = rs.getLong(1);
                            }
                        }
                        finally {
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            JdbcUtils.closeStatement((Statement)st);
                        }
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeStatement(ps);
                        throw throwable;
                    }
                }
                JdbcUtils.closeStatement((Statement)ps);
                return key;
            }
        });
    }

    @Override
    public Object createSavepoint() {
        return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                return transactionstatus.createSavepoint();
            }
        });
    }

    @Override
    public Object createSavepointForFallback() {
        if (this.requiresSavepointForFallback()) {
            return this.createSavepoint();
        }
        return null;
    }

    @Override
    public void rollbackToSavepoint(final Object savepoint) {
        if (savepoint != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                    transactionstatus.rollbackToSavepoint(savepoint);
                }
            });
        }
    }

    @Override
    public void releaseSavepoint(final Object savepoint) {
        if (savepoint != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                    transactionstatus.releaseSavepoint(savepoint);
                }
            });
        }
    }

    @Override
    public boolean requiresSavepointForFallback() {
        return false;
    }

    @Override
    public void disableSyncTriggers() {
        this.disableSyncTriggers(null);
    }

    @Override
    public boolean supportsTransactionId() {
        return false;
    }

    @Override
    public boolean isBlobSyncSupported() {
        return true;
    }

    @Override
    public boolean isClobSyncSupported() {
        return true;
    }

    @Override
    public boolean isTransactionIdOverrideSupported() {
        return true;
    }

    @Override
    public boolean storesUpperCaseNamesInCatalog() {
        return false;
    }

    @Override
    public boolean storesLowerCaseNamesInCatalog() {
        return false;
    }

    public void setSqlTemplate(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    @Override
    public SQLErrorCodeSQLExceptionTranslator getSqlErrorTranslator() {
        return this.sqlErrorTranslator;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public int getStreamingResultsFetchSize() {
        return this.streamingResultsFetchSize;
    }

    public void setStreamingResultsFetchSize(int streamingResultsFetchSize) {
        this.streamingResultsFetchSize = streamingResultsFetchSize;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public String getEngineName() {
        return this.parameterService.getString("engine.name").toLowerCase();
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public String getInitialLoadTableAlias() {
        return "t";
    }

    @Override
    public String preProcessTriggerSqlClause(String sqlClause) {
        return sqlClause;
    }

    @Override
    public int getRouterDataPeekAheadCount() {
        return this.parameterService.getInt("routing.peek.ahead.window.after.max.size");
    }

    @Override
    public String getDefaultSchema() {
        return StringUtils.isBlank((String)this.defaultSchema) ? null : this.defaultSchema;
    }

    public void setDefaultSchema(String currentSchema) {
        this.defaultSchema = currentSchema;
    }

    @Override
    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("truncate table " + tableName);
    }

    @Override
    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Override
    public boolean areDatabaseTransactionsPendingSince(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDatabaseTime() {
        try {
            return ((java.util.Date)this.jdbcTemplate.queryForObject("select current_timestamp from " + this.tablePrefix + "_node_identity", java.util.Date.class)).getTime();
        }
        catch (Exception ex) {
            this.log.error(ex);
            return System.currentTimeMillis();
        }
    }

    @Override
    public String getSourceNodeExpression() {
        return null;
    }

    @Override
    public String massageDataExtractionSql(String sql, String channelId) {
        return sql;
    }
}

