/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Version {
    static final Log log = LogFactory.getLog(Version.class);
    public static final int MAJOR_INDEX = 0;
    public static final int MINOR_INDEX = 1;
    public static final int PATCH_INDEX = 2;
    private static String version = null;

    public static String version() {
        if (version == null) {
            InputStream is = Version.class.getResourceAsStream("/META-INF/maven/org.jumpmind.symmetric/symmetric/pom.properties");
            if (is != null) {
                Properties p = new Properties();
                try {
                    p.load(is);
                    version = p.getProperty("version");
                }
                catch (IOException e) {
                    version = "unknown";
                    log.warn((Object)e, (Throwable)e);
                }
            } else {
                version = "development";
            }
        }
        return version;
    }

    public static String versionWithUnderscores() {
        return Version.version().replace("[\\.\\-]", "_");
    }

    public static int[] parseVersion(String version) {
        version = version.replaceAll("[^0-9\\.]", "");
        int[] versions = new int[3];
        if (!StringUtils.isEmpty((String)version)) {
            String[] splitVersion = version.split("\\.");
            if (splitVersion.length >= 3) {
                versions[2] = Version.parseVersionComponent(splitVersion[2]);
            }
            if (splitVersion.length >= 2) {
                versions[1] = Version.parseVersionComponent(splitVersion[1]);
            }
            if (splitVersion.length >= 1) {
                versions[0] = Version.parseVersionComponent(splitVersion[0]);
            }
        }
        return versions;
    }

    private static int parseVersionComponent(String versionComponent) {
        int version = 0;
        try {
            version = Integer.parseInt(versionComponent);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    protected static boolean isOlderMajorVersion(String version) {
        return Version.isOlderMajorVersion(Version.parseVersion(version));
    }

    protected static boolean isOlderMajorVersion(int[] versions) {
        int[] softwareVersion = Version.parseVersion(Version.version());
        return versions[0] < softwareVersion[0];
    }

    public static boolean isOlderVersion(String version) {
        return Version.isOlderThanVersion(version, Version.version());
    }

    public static boolean isOlderThanVersion(String checkVersion, String targetVersion) {
        int[] targetVersions;
        if (Version.noVersion(targetVersion) || Version.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = Version.parseVersion(checkVersion);
        if (checkVersions[0] < (targetVersions = Version.parseVersion(targetVersion))[0]) {
            return true;
        }
        if (checkVersions[0] == targetVersions[0] && checkVersions[1] < targetVersions[1]) {
            return true;
        }
        return checkVersions[0] == targetVersions[0] && checkVersions[1] == targetVersions[1] && checkVersions[2] < targetVersions[2];
    }

    private static boolean noVersion(String targetVersion) {
        return StringUtils.isBlank((String)targetVersion);
    }
}

