/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.util.ArrayList;
import java.util.EventListener;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.XSLTProcessor;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.SymmetricEngineContextLoaderListener;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.web.SymmetricFilter;
import org.jumpmind.symmetric.web.SymmetricServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SymmetricWebServer
implements ApplicationContextAware {
    protected static final ILog log = LogFactory.getLog(SymmetricWebServer.class);
    protected SymmetricEngineContextLoaderListener contextListener;
    protected Server server;
    protected boolean join = true;
    protected boolean createJmxServer = true;
    protected String webHome = "/sync";
    protected int maxIdleTime = 900000;
    protected int httpPort = -1;
    protected int httpsPort = -1;
    protected String propertiesFile;
    protected String host;
    protected boolean noNio = false;
    protected boolean noDirectBuffer = false;
    protected ApplicationContext parentContext;

    public SymmetricWebServer() {
    }

    public SymmetricWebServer(String propertiesUrl) {
        this.propertiesFile = propertiesUrl;
    }

    public SymmetricWebServer(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public SymmetricWebServer(int maxIdleTime, String propertiesUrl, boolean join, boolean noNio, boolean noDirectBuffer) {
        this.propertiesFile = propertiesUrl;
        this.maxIdleTime = maxIdleTime;
        this.join = join;
        this.noDirectBuffer = noDirectBuffer;
        this.noNio = noNio;
    }

    public SymmetricWebServer(int maxIdleTime, String propertiesUrl) {
        this.propertiesFile = propertiesUrl;
        this.maxIdleTime = maxIdleTime;
    }

    public void start(int port, String propertiesUrl) throws Exception {
        this.propertiesFile = propertiesUrl;
        this.start(port);
    }

    public ISymmetricEngine getEngine() {
        if (this.contextListener == null) {
            this.contextListener = new SymmetricEngineContextLoaderListener(new StandaloneSymmetricEngine(this.parentContext, true, this.propertiesFile));
        }
        return this.contextListener.getEngine();
    }

    public void start() throws Exception {
        if (this.httpPort > 0 && this.httpsPort > 0) {
            this.startMixed(this.httpPort, this.httpsPort);
        } else if (this.httpPort > 0) {
            this.start(this.httpPort);
        } else if (this.httpsPort > 0) {
            this.startSecure(this.httpsPort);
        } else {
            throw new IllegalStateException("Either an http or https port needs to be set before starting the server.");
        }
    }

    public SymmetricWebServer start(int port) throws Exception {
        return this.start(port, 0, Mode.HTTP);
    }

    public SymmetricWebServer startSecure(int port) throws Exception {
        return this.start(0, port, Mode.HTTPS);
    }

    public SymmetricWebServer startMixed(int port, int securePort) throws Exception {
        return this.start(port, securePort, Mode.MIXED);
    }

    public SymmetricWebServer start(int port, int securePort, Mode mode) throws Exception {
        this.getEngine();
        this.server = new Server();
        this.server.setConnectors(this.getConnectors(port, securePort, mode));
        Context webContext = new Context((HandlerContainer)this.server, this.webHome, 0);
        if (this.contextListener == null) {
            this.contextListener = new SymmetricEngineContextLoaderListener();
        }
        webContext.addEventListener((EventListener)((Object)this.contextListener));
        webContext.addFilter(SymmetricFilter.class, "/*", 0);
        ServletHolder servletHolder = new ServletHolder(SymmetricServlet.class);
        servletHolder.setInitOrder(0);
        webContext.addServlet(servletHolder, "/*");
        this.setupBasicAuthIfNeeded(webContext);
        this.server.addHandler((Handler)webContext);
        this.server.start();
        if (this.createJmxServer) {
            int httpJmxPort = port != 0 ? port + 1 : securePort + 1;
            this.registerHttpJmxAdaptor(httpJmxPort);
        }
        if (this.join) {
            this.server.join();
        }
        return this;
    }

    protected void setupBasicAuthIfNeeded(Context webContext) {
        String basicAuthUsername = this.getEngine().getParameterService().getString("embedded.webserver.basic.auth.username");
        if (StringUtils.isNotBlank((String)basicAuthUsername)) {
            String basicAuthPassword = this.getEngine().getParameterService().getString("embedded.webserver.basic.auth.password");
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setRoles(new String[]{"symmetric"});
            constraint.setAuthenticate(true);
            ConstraintMapping cm = new ConstraintMapping();
            cm.setConstraint(constraint);
            cm.setPathSpec("/*");
            SecurityHandler sh = new SecurityHandler();
            HashUserRealm realm = new HashUserRealm();
            realm.put((Object)basicAuthUsername, (Object)basicAuthPassword);
            realm.addUserToRole(basicAuthUsername, "symmetric");
            sh.setUserRealm((UserRealm)realm);
            sh.setConstraintMappings(new ConstraintMapping[]{cm});
            webContext.addHandler((Handler)sh);
        }
    }

    protected Connector[] getConnectors(int port, int securePort, Mode mode) {
        SocketConnector connector;
        ArrayList<SocketConnector> connectors = new ArrayList<SocketConnector>();
        String keyStoreFile = System.getProperty("sym.keystore.file");
        if (mode.equals((Object)Mode.HTTP) || mode.equals((Object)Mode.MIXED)) {
            connector = null;
            if (this.noNio) {
                connector = new SocketConnector();
            } else {
                SelectChannelConnector nioConnector = new SelectChannelConnector();
                connector = nioConnector;
                nioConnector.setUseDirectBuffers(!this.noDirectBuffer);
                nioConnector.setMaxIdleTime(this.maxIdleTime);
            }
            connector.setPort(port);
            connector.setHost(this.host);
            connectors.add(connector);
            log.info("WebServerStarting", port);
        }
        if (mode.equals((Object)Mode.HTTPS) || mode.equals((Object)Mode.MIXED)) {
            connector = new SslSocketConnector();
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            keyStorePassword = keyStorePassword != null ? keyStorePassword : "changeit";
            ((SslSocketConnector)connector).setKeystore(keyStoreFile);
            ((SslSocketConnector)connector).setKeyPassword(keyStorePassword);
            ((SslSocketConnector)connector).setMaxIdleTime(this.maxIdleTime);
            connector.setPort(securePort);
            connector.setHost(this.host);
            connectors.add(connector);
            log.info("WebServerSecureStarting", securePort);
        }
        return connectors.toArray(new Connector[connectors.size()]);
    }

    protected void registerHttpJmxAdaptor(int jmxPort) throws Exception {
        IParameterService parameterService = (IParameterService)AppUtils.find("parameterService", this.getEngine());
        if (parameterService.is("jmx.http.console.for.embedded.webserver.enabled")) {
            log.info("JMXConsoleStarting", jmxPort);
            MBeanServer mbeanServer = (MBeanServer)AppUtils.find("mbeanserver", this.getEngine());
            ObjectName name = this.getHttpJmxAdaptorName();
            mbeanServer.createMBean(HttpAdaptor.class.getName(), name);
            if (!parameterService.is("jmx.http.console.localhost.only.enabled")) {
                mbeanServer.setAttribute(name, new Attribute("Host", "0.0.0.0"));
            }
            mbeanServer.setAttribute(name, new Attribute("Port", new Integer(jmxPort)));
            ObjectName processorName = this.getXslJmxAdaptorName();
            mbeanServer.createMBean(XSLTProcessor.class.getName(), processorName);
            mbeanServer.setAttribute(name, new Attribute("ProcessorName", processorName));
            mbeanServer.invoke(name, "start", null, null);
        }
    }

    protected ObjectName getHttpJmxAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=HttpAdaptor");
    }

    protected ObjectName getXslJmxAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=XSLTProcessor");
    }

    protected void removeHttpJmxAdaptor() {
        IParameterService parameterService = (IParameterService)AppUtils.find("parameterService", this.getEngine());
        if (parameterService.is("jmx.http.console.for.embedded.webserver.enabled")) {
            try {
                MBeanServer mbeanServer = (MBeanServer)AppUtils.find("mbeanserver", this.getEngine());
                mbeanServer.unregisterMBean(this.getHttpJmxAdaptorName());
                mbeanServer.unregisterMBean(this.getXslJmxAdaptorName());
            }
            catch (Exception e) {
                log.warn("JMXAdaptorUnregisterFailed");
            }
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            if (this.createJmxServer) {
                this.removeHttpJmxAdaptor();
            }
            this.server.stop();
        }
    }

    public SymmetricEngineContextLoaderListener getContextListener() {
        return this.contextListener;
    }

    public void setContextListener(SymmetricEngineContextLoaderListener contextListener) {
        this.contextListener = contextListener;
    }

    public static void main(String[] args) throws Exception {
        new SymmetricWebServer().start(8080);
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public void setWebHome(String webHome) {
        this.webHome = webHome;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.parentContext = context;
    }

    public void setCreateJmxServer(boolean createJmxServer) {
        this.createJmxServer = createJmxServer;
    }

    public void setHost(String host) {
        this.host = host;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        MIXED;

    }
}

