/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.sql.Connection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.jumpmind.symmetric.common.Message;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SymmetricLauncher {
    private static final String OPTION_DUMP_BATCH = "dump-batch";
    private static final String OPTION_OPEN_REGISTRATION = "open-registration";
    private static final String OPTION_RELOAD_NODE = "reload-node";
    private static final String OPTION_AUTO_CREATE = "auto-create";
    private static final String OPTION_PORT_SERVER = "port";
    private static final String OPTION_SECURE_PORT_SERVER = "secure-port";
    private static final String OPTION_MAX_IDLE_TIME = "max-idle-time";
    private static final String OPTION_DDL_GEN = "generate-config-ddl";
    private static final String OPTION_TRIGGER_GEN = "generate-triggers";
    private static final String OPTION_TRIGGER_GEN_ALWAYS = "generate-triggers-always";
    private static final String OPTION_PURGE = "purge";
    private static final String OPTION_RUN_DDL_XML = "run-ddl";
    private static final String OPTION_RUN_SQL = "run-sql";
    private static final String OPTION_PROPERTIES_GEN = "generate-default-properties";
    private static final String OPTION_EXPORT_SCHEMA = "export-schema";
    private static final String OPTION_PROPERTIES_FILE = "properties";
    private static final String OPTION_START_SERVER = "server";
    private static final String OPTION_START_CLIENT = "client";
    private static final String OPTION_START_SECURE_SERVER = "secure-server";
    private static final String OPTION_START_MIXED_SERVER = "mixed-server";
    private static final String OPTION_NO_NIO = "no-nio";
    private static final String OPTION_NO_DIRECT_BUFFER = "no-directbuffer";
    private static final String OPTION_LOAD_BATCH = "load-batch";
    private static final String OPTION_SKIP_DB_VALIDATION = "skip-db-validate";
    private static final String OPTION_ENCRYPT_TEXT = "encrypt";
    private static final String OPTION_VERBOSE_CONSOLE = "verbose";
    private static final String MESSAGE_BUNDLE = "Launcher.Option.";
    protected static SymmetricWebServer webServer;
    protected static Exception exception;
    protected static boolean join;

    public static void main(String ... args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = SymmetricLauncher.buildOptions();
        try {
            String arg;
            CommandLine line = parser.parse(options, args);
            int port = 31415;
            int securePort = 31417;
            int maxIdleTime = 900000;
            String propertiesFile = null;
            boolean noNio = false;
            boolean noDirectBuffer = false;
            if (line.hasOption(OPTION_VERBOSE_CONSOLE)) {
                System.setProperty("org.apache.commons.logging.Log", SimpleLog.class.getName());
                System.setProperty("org.apache.commons.logging.simplelog.showlogname", "false");
                System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "info");
                System.setProperty("org.apache.commons.logging.simplelog.log.org", "error");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.jumpmind", "info");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.jumpmind.symmetric.config.PropertiesFactoryBean", "error");
            } else {
                System.out.println(Message.get("LauncherLogLocation"));
                if (line.getOptions() != null) {
                    for (Option option : line.getOptions()) {
                        LogFactory.getLog(SymmetricLauncher.class).info("Option", option.getLongOpt(), ArrayUtils.toString((Object)option.getValues()));
                    }
                }
            }
            if (line.hasOption(OPTION_PORT_SERVER)) {
                port = new Integer(line.getOptionValue(OPTION_PORT_SERVER));
            }
            if (line.hasOption(OPTION_SECURE_PORT_SERVER)) {
                securePort = new Integer(line.getOptionValue(OPTION_SECURE_PORT_SERVER));
            }
            if (line.hasOption(OPTION_MAX_IDLE_TIME)) {
                maxIdleTime = new Integer(line.getOptionValue(OPTION_MAX_IDLE_TIME));
            }
            if (line.hasOption(OPTION_NO_NIO)) {
                noNio = true;
            }
            if (line.hasOption(OPTION_NO_DIRECT_BUFFER)) {
                noDirectBuffer = true;
            }
            if (line.hasOption(OPTION_PROPERTIES_GEN)) {
                SymmetricLauncher.generateDefaultProperties(line.getOptionValue(OPTION_PROPERTIES_GEN));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_PROPERTIES_FILE)) {
                propertiesFile = "file:" + line.getOptionValue(OPTION_PROPERTIES_FILE);
                System.setProperty("symmetric.override.properties.file.1", propertiesFile);
                if (!new File(line.getOptionValue(OPTION_PROPERTIES_FILE)).exists()) {
                    throw new SymmetricException("FilePropertiesNotFound", line.getOptionValue(OPTION_PROPERTIES_FILE));
                }
            }
            if (line.hasOption(OPTION_DDL_GEN)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.generateDDL(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_DDL_GEN));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_PURGE)) {
                SymmetricLauncher.testConnection(line);
                ((IPurgeService)new StandaloneSymmetricEngine(propertiesFile).getApplicationContext().getBean("purgeService")).purge();
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_OPEN_REGISTRATION)) {
                SymmetricLauncher.testConnection(line);
                arg = line.getOptionValue(OPTION_OPEN_REGISTRATION);
                SymmetricLauncher.openRegistration(new StandaloneSymmetricEngine(propertiesFile), arg);
                System.out.println(Message.get("RegistrationOpened", arg));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_RELOAD_NODE)) {
                SymmetricLauncher.testConnection(line);
                arg = line.getOptionValue(OPTION_RELOAD_NODE);
                String message = SymmetricLauncher.reloadNode(new StandaloneSymmetricEngine(propertiesFile), arg);
                System.out.println(message);
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_DUMP_BATCH)) {
                SymmetricLauncher.testConnection(line);
                arg = line.getOptionValue(OPTION_DUMP_BATCH);
                SymmetricLauncher.dumpBatch(new StandaloneSymmetricEngine(propertiesFile), arg);
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_TRIGGER_GEN)) {
                SymmetricLauncher.testConnection(line);
                arg = line.getOptionValue(OPTION_TRIGGER_GEN);
                boolean gen_always = line.hasOption(OPTION_TRIGGER_GEN_ALWAYS);
                SymmetricLauncher.syncTrigger(new StandaloneSymmetricEngine(propertiesFile), arg, gen_always);
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_AUTO_CREATE)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.autoCreateDatabase(new StandaloneSymmetricEngine(propertiesFile));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_EXPORT_SCHEMA)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.exportSchema(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_EXPORT_SCHEMA));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_RUN_DDL_XML)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.runDdlXml(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_RUN_DDL_XML));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_RUN_SQL)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.runSql(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_RUN_SQL));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_LOAD_BATCH)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.loadBatch(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_LOAD_BATCH));
                System.exit(0);
                return;
            }
            if (line.hasOption(OPTION_ENCRYPT_TEXT)) {
                SymmetricLauncher.testConnection(line);
                SymmetricLauncher.encryptText(new StandaloneSymmetricEngine(propertiesFile), line.getOptionValue(OPTION_ENCRYPT_TEXT));
                return;
            }
            if (line.hasOption(OPTION_START_CLIENT)) {
                new StandaloneSymmetricEngine(propertiesFile).start();
                return;
            }
            if (line.hasOption(OPTION_START_SERVER) || line.hasOption(OPTION_START_SECURE_SERVER) || line.hasOption(OPTION_START_MIXED_SERVER)) {
                webServer = new SymmetricWebServer(maxIdleTime, propertiesFile, join, noNio, noDirectBuffer);
                if (line.hasOption(OPTION_START_SERVER)) {
                    webServer.start(port);
                } else if (line.hasOption(OPTION_START_SECURE_SERVER)) {
                    webServer.startSecure(securePort);
                } else if (line.hasOption(OPTION_START_MIXED_SERVER)) {
                    webServer.startMixed(port, securePort);
                }
                return;
            }
            SymmetricLauncher.printHelp(options);
        }
        catch (ParseException exp) {
            exception = exp;
            System.err.println(exp.getMessage());
            SymmetricLauncher.printHelp(options);
            System.exit(-1);
        }
        catch (Exception ex) {
            exception = ex;
            System.err.println("-----------------------------------------------------------------------------------------------");
            System.err.println(Message.get("ExceptionGeneral"));
            System.err.println("-----------------------------------------------------------------------------------------------");
            ExceptionUtils.printRootCauseStackTrace((Throwable)ex, (PrintStream)System.err);
            System.err.println("-----------------------------------------------------------------------------------------------");
            System.exit(-1);
        }
    }

    private static void printHelp(Options options) {
        new HelpFormatter().printHelp("sym", options);
    }

    private static void testConnection(CommandLine line) throws Exception {
        if (!line.hasOption(OPTION_SKIP_DB_VALIDATION)) {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:/symmetric-properties.xml", "classpath:/symmetric-database.xml"});
            BasicDataSource ds = (BasicDataSource)ctx.getBean("dataSource");
            Connection c = ds.getConnection();
            c.close();
            ds.close();
        }
    }

    private static Options buildOptions() {
        Options options = new Options();
        SymmetricLauncher.addOption(options, "S", OPTION_START_SERVER, false);
        SymmetricLauncher.addOption(options, "C", OPTION_START_CLIENT, false);
        SymmetricLauncher.addOption(options, "T", OPTION_START_SECURE_SERVER, false);
        SymmetricLauncher.addOption(options, "U", OPTION_START_MIXED_SERVER, false);
        SymmetricLauncher.addOption(options, "P", OPTION_PORT_SERVER, true);
        SymmetricLauncher.addOption(options, "Q", OPTION_SECURE_PORT_SERVER, true);
        SymmetricLauncher.addOption(options, "I", OPTION_MAX_IDLE_TIME, true);
        SymmetricLauncher.addOption(options, "nnio", OPTION_NO_NIO, false);
        SymmetricLauncher.addOption(options, "ndb", OPTION_NO_DIRECT_BUFFER, false);
        SymmetricLauncher.addOption(options, "c", OPTION_DDL_GEN, true);
        SymmetricLauncher.addOption(options, "p", OPTION_PROPERTIES_FILE, true);
        SymmetricLauncher.addOption(options, "X", OPTION_PURGE, false);
        SymmetricLauncher.addOption(options, "g", OPTION_PROPERTIES_GEN, true);
        SymmetricLauncher.addOption(options, "r", OPTION_RUN_DDL_XML, true);
        SymmetricLauncher.addOption(options, "s", OPTION_RUN_SQL, true);
        SymmetricLauncher.addOption(options, "a", OPTION_AUTO_CREATE, false);
        SymmetricLauncher.addOption(options, "R", OPTION_OPEN_REGISTRATION, true);
        SymmetricLauncher.addOption(options, "l", OPTION_RELOAD_NODE, true);
        SymmetricLauncher.addOption(options, "d", OPTION_DUMP_BATCH, true);
        SymmetricLauncher.addOption(options, "b", OPTION_LOAD_BATCH, true);
        SymmetricLauncher.addOption(options, "t", OPTION_TRIGGER_GEN, true);
        SymmetricLauncher.addOption(options, "o", OPTION_TRIGGER_GEN_ALWAYS, false);
        SymmetricLauncher.addOption(options, "e", OPTION_ENCRYPT_TEXT, true);
        SymmetricLauncher.addOption(options, "v", OPTION_VERBOSE_CONSOLE, false);
        SymmetricLauncher.addOption(options, "x", OPTION_EXPORT_SCHEMA, true);
        return options;
    }

    private static void addOption(Options options, String opt, String longOpt, boolean hasArg) {
        options.addOption(opt, longOpt, hasArg, Message.get(MESSAGE_BUNDLE + longOpt));
    }

    private static void dumpBatch(ISymmetricEngine engine, String batchId) throws Exception {
        IDataExtractorService dataExtractorService = (IDataExtractorService)engine.getApplicationContext().getBean("dataExtractorService");
        InternalOutgoingTransport transport = new InternalOutgoingTransport(System.out);
        dataExtractorService.extractBatchRange(transport, batchId, batchId);
        transport.close();
    }

    private static void loadBatch(ISymmetricEngine engine, String fileName) throws Exception {
        IDataLoaderService service = (IDataLoaderService)engine.getApplicationContext().getBean("dataLoaderService");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("Launcher.Exception.FileNotFound", fileName);
        }
        FileInputStream in = new FileInputStream(file);
        service.loadData(in, System.out);
        System.out.flush();
        in.close();
    }

    private static void encryptText(ISymmetricEngine engine, String plainText) {
        ISecurityService service = (ISecurityService)engine.getApplicationContext().getBean("securityService");
        System.out.println("enc:" + service.encrypt(plainText));
    }

    private static void exportSchema(ISymmetricEngine engine, String fileName) {
        Platform platform = engine.getDbDialect().getPlatform();
        Database db = platform.readModelFromDatabase("model");
        new DatabaseIO().write(db, fileName);
    }

    private static void openRegistration(ISymmetricEngine engine, String argument) {
        int index = (argument = argument.replace('\"', ' ')).trim().indexOf(",");
        if (index < 0) {
            throw new SymmetricException("LauncherMissingFilenameTriggerSQL", OPTION_OPEN_REGISTRATION);
        }
        String nodeGroupId = argument.substring(0, index).trim();
        String externalId = argument.substring(index + 1).trim();
        IRegistrationService registrationService = (IRegistrationService)engine.getApplicationContext().getBean("registrationService");
        registrationService.openRegistration(nodeGroupId, externalId);
    }

    private static String reloadNode(ISymmetricEngine engine, String argument) {
        IDataService dataService = (IDataService)engine.getApplicationContext().getBean("dataService");
        return dataService.reloadNode(argument);
    }

    private static void syncTrigger(ISymmetricEngine engine, String fileName, boolean gen_always) throws IOException {
        File file;
        if (fileName != null) {
            file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
        } else {
            throw new SymmetricException("MissingFilenameTriggerSQL");
        }
        ITriggerRouterService triggerService = (ITriggerRouterService)AppUtils.find("triggerRouterService", engine);
        StringBuilder sqlBuffer = new StringBuilder();
        triggerService.syncTriggers(sqlBuffer, gen_always);
        FileUtils.writeStringToFile((File)file, (String)sqlBuffer.toString(), null);
    }

    private static void generateDDL(ISymmetricEngine engine, String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileWriter os = new FileWriter(file, false);
        os.write(((IDbDialect)engine.getApplicationContext().getBean("dbDialect")).getCreateSymmetricDDL());
        os.close();
    }

    private static void generateDefaultProperties(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(SymmetricLauncher.class.getResourceAsStream("/symmetric-default.properties"), Charset.defaultCharset()));
        FileWriter os = new FileWriter(file, false);
        String line = is.readLine();
        while (line != null) {
            os.write(line);
            os.write(System.getProperty("line.separator"));
            line = is.readLine();
        }
        is.close();
        os.close();
    }

    private static void autoCreateDatabase(StandaloneSymmetricEngine engine) {
        engine.setupDatabase(true);
    }

    private static void runDdlXml(ISymmetricEngine engine, String fileName) throws FileNotFoundException {
        IDbDialect dialect = (IDbDialect)engine.getApplicationContext().getBean("dbDialect");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("FileNotFound", fileName);
        }
        Platform pf = dialect.getPlatform();
        Database db = new DatabaseIO().read(new File(fileName));
        pf.createTables(db, false, true);
    }

    private static void runSql(ISymmetricEngine engine, String fileName) throws FileNotFoundException, MalformedURLException {
        IDbDialect dialect = (IDbDialect)engine.getApplicationContext().getBean("dbDialect");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("FileNotFound", fileName);
        }
        SqlScript script = new SqlScript(file.toURI().toURL(), dialect.getPlatform().getDataSource());
        script.execute();
    }

    static {
        join = true;
    }
}

