/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SymmetricEngineContextLoaderListener
extends ContextLoaderListener {
    static final String SYMMETRIC_SPRING_LOCATION = "classpath:/symmetric.xml";
    static final String SYMMETRIC_EMPTY_SPRING_LOCATION = "classpath:/symmetric-empty.xml";
    static final ILog log = LogFactory.getLog(SymmetricEngineContextLoaderListener.class);
    ISymmetricEngine engine = null;

    public SymmetricEngineContextLoaderListener() {
    }

    public SymmetricEngineContextLoaderListener(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public final void contextInitialized(ServletContextEvent event) {
        try {
            super.contextInitialized(event);
            this.createConfigureAndStartEngine((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getServletContext()));
        }
        catch (Exception ex) {
            log.error("WebServerInitializeError", ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.engine != null) {
            this.engine.stop();
            this.engine = null;
        }
    }

    protected void createConfigureAndStartEngine(ApplicationContext ctx) {
        if (this.engine == null) {
            this.engine = new StandaloneSymmetricEngine(ctx, !ctx.containsBean("symmetricProperties"));
        }
        this.engine.start();
    }

    protected ContextLoader createContextLoader() {
        return new ContextLoader(){

            protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
                if (SymmetricEngineContextLoaderListener.this.engine == null) {
                    String[] configLocation = applicationContext.getConfigLocations();
                    String[] newconfigLocation = new String[configLocation.length + 1];
                    newconfigLocation[0] = SymmetricEngineContextLoaderListener.SYMMETRIC_SPRING_LOCATION;
                    boolean symmetricConfigured = false;
                    for (int i = 0; i < configLocation.length; ++i) {
                        String config = configLocation[i];
                        if (config.equals(SymmetricEngineContextLoaderListener.SYMMETRIC_SPRING_LOCATION)) {
                            symmetricConfigured = true;
                        }
                        newconfigLocation[i + 1] = configLocation[i];
                    }
                    if (!symmetricConfigured) {
                        applicationContext.setConfigLocations(newconfigLocation);
                    }
                } else {
                    applicationContext.setParent(SymmetricEngineContextLoaderListener.this.engine.getApplicationContext());
                    applicationContext.setConfigLocation(SymmetricEngineContextLoaderListener.SYMMETRIC_EMPTY_SPRING_LOCATION);
                }
            }
        };
    }

    public ISymmetricEngine getEngine() {
        return this.engine;
    }
}

