/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ext.IExtensionPointManager;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.IUpgradeService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSymmetricEngine
implements ISymmetricEngine {
    protected final ILog log = LogFactory.getLog(this.getClass());
    private static Map<String, ISymmetricEngine> registeredEnginesByUrl = new HashMap<String, ISymmetricEngine>();
    private static Map<String, ISymmetricEngine> registeredEnginesByName = new HashMap<String, ISymmetricEngine>();
    private ApplicationContext applicationContext;
    private JdbcTemplate jdbcTemplate;
    private boolean started = false;
    private boolean starting = false;
    private boolean setup = false;
    private IDbDialect dbDialect;
    private IJobManager jobManager;

    protected AbstractSymmetricEngine() {
    }

    public static ISymmetricEngine findEngineByUrl(String url) {
        if (registeredEnginesByUrl != null && url != null) {
            return registeredEnginesByUrl.get(url);
        }
        return null;
    }

    public static ISymmetricEngine findEngineByName(String name) {
        if (registeredEnginesByName != null && name != null) {
            return registeredEnginesByName.get(name.toLowerCase());
        }
        return null;
    }

    public static ISymmetricEngine getEngine() {
        int numberOfEngines = registeredEnginesByName.size();
        if (numberOfEngines == 0) {
            return null;
        }
        if (numberOfEngines > 1) {
            throw new IllegalStateException("More than one SymmetricEngine is currently registered");
        }
        return registeredEnginesByName.values().iterator().next();
    }

    @Override
    public boolean isConfigured() {
        return this.getParameterService() != null && !StringUtils.isBlank((String)this.getParameterService().getNodeGroupId()) && !StringUtils.isBlank((String)this.getParameterService().getExternalId()) && !StringUtils.isBlank((String)this.getParameterService().getSyncUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        if (!this.starting && !this.started) {
            try {
                this.starting = true;
                AppUtils.cleanupTempFiles();
                this.getParameterService().rereadParameters();
                this.setup();
                this.validateConfiguration();
                this.registerEngine();
                this.startDefaultServerJMXExport();
                Node node = this.getNodeService().findIdentity();
                if (node != null) {
                    this.log.info("RegisteredNodeStarting", node.getNodeGroupId(), node.getNodeId(), node.getExternalId());
                } else {
                    this.log.info("UnregisteredNodeStarting", this.getParameterService().getNodeGroupId(), this.getParameterService().getExternalId());
                }
                this.getTriggerService().syncTriggers();
                this.heartbeat(false);
                this.jobManager.startJobs();
                this.log.info("SymmetricDSStarted", this.getParameterService().getExternalId(), Version.version(), this.dbDialect.getName(), this.dbDialect.getVersion());
                this.started = true;
                Object var3_2 = null;
                this.starting = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.starting = false;
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.log.info("SymmetricDSClosing", this.getParameterService().getExternalId(), Version.version(), this.dbDialect.getName());
        this.jobManager.stopJobs();
        this.removeMeFromMap(registeredEnginesByName);
        this.removeMeFromMap(registeredEnginesByUrl);
        DataSource ds = this.jdbcTemplate.getDataSource();
        if (ds instanceof BasicDataSource) {
            try {
                ((BasicDataSource)ds).close();
            }
            catch (SQLException ex) {
                this.log.error(ex);
            }
        }
        this.applicationContext = null;
        this.jdbcTemplate = null;
        this.dbDialect = null;
        this.started = false;
        this.starting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init(ApplicationContext ctx, boolean isParentContext, Properties overrideProperties, String overridePropertiesResource1, String overridePropertiesResource2) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (overrideProperties != null) {
                FileOutputStream fos = null;
                try {
                    try {
                        File file = File.createTempFile("symmetric.", ".properties");
                        fos = new FileOutputStream(file);
                        overrideProperties.store(fos, "");
                        System.setProperty("symmetric.override.properties.file.temp", "file:" + file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        this.log.error(ex);
                        throw new RuntimeException(ex);
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
            System.setProperty("symmetric.override.properties.file.1", overridePropertiesResource1 == null ? "" : overridePropertiesResource1);
            System.setProperty("symmetric.override.properties.file.2", overridePropertiesResource2 == null ? "" : overridePropertiesResource2);
            if (isParentContext || ctx == null) {
                this.init(this.createContext(ctx));
            } else {
                this.init(ctx);
            }
            return;
        }
    }

    protected void init(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.dbDialect = (IDbDialect)AppUtils.find("dbDialect", this);
        this.jobManager = (IJobManager)AppUtils.find("jobManager", this);
        this.jdbcTemplate = (JdbcTemplate)AppUtils.find("jdbcTemplate", this);
        IExtensionPointManager extMgr = (IExtensionPointManager)this.applicationContext.getBean("extensionManager");
        extMgr.register();
    }

    private ApplicationContext createContext(ApplicationContext parentContext) {
        return new ClassPathXmlApplicationContext(new String[]{"classpath:/symmetric.xml"}, parentContext);
    }

    private void removeMeFromMap(Map<String, ISymmetricEngine> map) {
        HashSet<String> keys = new HashSet<String>(map.keySet());
        for (String key : keys) {
            if (!map.get(key).equals(this)) continue;
            map.remove(key);
        }
    }

    private void registerEngine() {
        registeredEnginesByUrl.put(this.getSyncUrl(), this);
        registeredEnginesByName.put(this.getEngineName(), this);
    }

    @Override
    public String getSyncUrl() {
        Node node = this.getNodeService().findIdentity();
        if (node != null) {
            return node.getSyncUrl();
        }
        return this.getParameterService().getSyncUrl();
    }

    private void startDefaultServerJMXExport() {
        if (this.getParameterService().is("jmx.legacy.beans.enabled")) {
            try {
                this.getApplicationContext().getBean("defaultServerExporter");
            }
            catch (Exception ex) {
                this.log.warn("JMXBeansRegisterError ", ex.getMessage());
            }
        }
    }

    @Override
    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll(this.getParameterService().getAllParameters());
        return p;
    }

    @Override
    public String getEngineName() {
        return this.dbDialect.getEngineName();
    }

    @Override
    public synchronized void setup() {
        if (!this.setup) {
            this.setupDatabase(false);
            this.setup = true;
        }
    }

    @Override
    public String reloadNode(String nodeId) {
        return this.getDataService().reloadNode(nodeId);
    }

    @Override
    public String sendSQL(String nodeId, String tableName, String sql) {
        return this.getDataService().sendSQL(nodeId, tableName, sql);
    }

    @Override
    public boolean push() {
        return ((IPushService)this.applicationContext.getBean("pushService")).pushData();
    }

    @Override
    public void syncTriggers() {
        this.getTriggerService().syncTriggers();
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.getNodeService().getNodeStatus();
    }

    @Override
    public boolean pull() {
        return ((IPullService)this.applicationContext.getBean("pullService")).pullData();
    }

    @Override
    public void purge() {
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.getParameterService().getString("start.purge.job"))) {
            throw new UnsupportedOperationException("Cannot actuate a purge if it is already scheduled.");
        }
        this.getPurgeService().purge();
    }

    protected void setupDatabase(boolean force) {
        this.getConfigurationService().autoConfigDatabase(force);
        if (this.getUpgradeService().isUpgradeNecessary()) {
            if (this.getParameterService().is("auto.upgrade")) {
                try {
                    if (!this.getUpgradeService().isUpgradePossible()) {
                        throw new SymmetricException("SymmetricDSManualUpgradeNeeded", this.getNodeService().findSymmetricVersion(), Version.version());
                    }
                    this.getUpgradeService().upgrade();
                    this.getConfigurationService().autoConfigDatabase(force);
                }
                catch (RuntimeException ex) {
                    this.log.fatal("SymmetricDSUpgradeFailed", ex);
                    throw ex;
                }
            } else {
                throw new SymmetricException("SymmetricDSUpgradeNeeded");
            }
        }
        this.getClusterService().initLockTable();
    }

    @Override
    public void validateConfiguration() {
        Node node = this.getNodeService().findIdentity();
        if (node == null && StringUtils.isBlank((String)this.getParameterService().getRegistrationUrl())) {
            throw new IllegalStateException(String.format("Please set the property %s so this node may pull registration or manually insert configuration into the configuration tables.", "registration.url"));
        }
        if (!(node == null || node.getExternalId().equals(this.getParameterService().getExternalId()) && node.getNodeGroupId().equals(this.getParameterService().getNodeGroupId()))) {
            throw new IllegalStateException("The configured state does not match recorded database state.  The recorded external id is " + node.getExternalId() + " while the configured external id is " + this.getParameterService().getExternalId() + ".  The recorded node group id is " + node.getNodeGroupId() + " while the configured node group id is " + this.getParameterService().getNodeGroupId());
        }
        if (node != null && StringUtils.isBlank((String)this.getParameterService().getRegistrationUrl()) && StringUtils.isBlank((String)this.getParameterService().getSyncUrl())) {
            throw new IllegalStateException("The sync.url property must be set for the registration server.  Otherwise, registering nodes will not be able to sync with it.");
        }
        long offlineNodeDetectionPeriodSeconds = this.getParameterService().getLong("offline.node.detection.period.minutes") * 60L;
        long heartbeatSeconds = this.getParameterService().getLong("heartbeat.sync.on.push.period.sec");
        if (offlineNodeDetectionPeriodSeconds > 0L && offlineNodeDetectionPeriodSeconds <= heartbeatSeconds) {
            throw new IllegalStateException("The offline.node.detection.period.minutes property must be a longer period of time than the heartbeat.sync.on.push.period.sec property.  Otherwise, nodes will be taken offline before the heartbeat job has a chance to run.");
        }
    }

    @Override
    public void heartbeat(boolean force) {
        this.getDataService().heartbeat(force);
    }

    @Override
    public void openRegistration(String groupId, String externalId) {
        this.getRegistrationService().openRegistration(groupId, externalId);
    }

    @Override
    public void reOpenRegistration(String nodeId) {
        this.getRegistrationService().reOpenRegistration(nodeId);
    }

    @Override
    public boolean isRegistered() {
        return this.getNodeService().findIdentity() != null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public IConfigurationService getConfigurationService() {
        return (IConfigurationService)AppUtils.find("configurationService", this);
    }

    @Override
    public IParameterService getParameterService() {
        return (IParameterService)AppUtils.find("parameterService", this);
    }

    @Override
    public INodeService getNodeService() {
        return (INodeService)AppUtils.find("nodeService", this);
    }

    @Override
    public IRegistrationService getRegistrationService() {
        return (IRegistrationService)AppUtils.find("registrationService", this);
    }

    @Override
    public IUpgradeService getUpgradeService() {
        return (IUpgradeService)AppUtils.find("upgradeService", this);
    }

    @Override
    public IClusterService getClusterService() {
        return (IClusterService)AppUtils.find("clusterService", this);
    }

    @Override
    public IPurgeService getPurgeService() {
        return (IPurgeService)AppUtils.find("purgeService", this);
    }

    @Override
    public ITriggerRouterService getTriggerService() {
        return (ITriggerRouterService)AppUtils.find("triggerRouterService", this);
    }

    @Override
    public IDataService getDataService() {
        return (IDataService)AppUtils.find("dataService", this);
    }

    @Override
    public IDbDialect getDbDialect() {
        return this.dbDialect;
    }

    @Override
    public IJobManager getJobManager() {
        return this.jobManager;
    }

    @Override
    public IOutgoingBatchService getOutgoingBatchService() {
        return (IOutgoingBatchService)AppUtils.find("outgoingBatchService", this);
    }

    @Override
    public IAcknowledgeService getAcknowledgeService() {
        return (IAcknowledgeService)AppUtils.find("acknowledgeService", this);
    }

    @Override
    public IBandwidthService getBandwidthService() {
        return (IBandwidthService)AppUtils.find("bandwidthService", this);
    }

    @Override
    public IDataExtractorService getDataExtractorService() {
        return (IDataExtractorService)AppUtils.find("dataExtractorService", this);
    }

    @Override
    public IDataLoaderService getDataLoaderService() {
        return (IDataLoaderService)AppUtils.find("dataLoaderService", this);
    }

    @Override
    public IIncomingBatchService getIncomingBatchService() {
        return (IIncomingBatchService)AppUtils.find("incomingBatchService", this);
    }

    @Override
    public IPullService getPullService() {
        return (IPullService)AppUtils.find("pullService", this);
    }

    @Override
    public IPushService getPushService() {
        return (IPushService)AppUtils.find("pushService", this);
    }

    @Override
    public IRouterService getRouterService() {
        return (IRouterService)AppUtils.find("routingService", this);
    }

    @Override
    public ISecurityService getSecurityService() {
        return (ISecurityService)AppUtils.find("securityService", this);
    }

    @Override
    public IStatisticService getStatisticService() {
        return (IStatisticService)AppUtils.find("statisticService", this);
    }

    @Override
    public ITriggerRouterService getTriggerRouterService() {
        return (ITriggerRouterService)AppUtils.find("triggerRouterService", this);
    }
}

