/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportMasterNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSnapshotsStatusAction.class);
    private final SnapshotsService snapshotsService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, SnapshotsStatusRequest::new, indexNameExpressionResolver);
        this.snapshotsService = snapshotsService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected SnapshotsStatusResponse read(StreamInput in) throws IOException {
        return new SnapshotsStatusResponse(in);
    }

    @Override
    protected void masterOperation(SnapshotsStatusRequest request, ClusterState state, ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        List<SnapshotsInProgress.Entry> currentSnapshots = this.snapshotsService.currentSnapshots(request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            this.buildResponse(request, currentSnapshots, null, listener);
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (ObjectCursor status : entry.shards().values()) {
                if (((SnapshotsInProgress.ShardSnapshotStatus)status.value).nodeId() == null) continue;
                nodesIds.add(((SnapshotsInProgress.ShardSnapshotStatus)status.value).nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = currentSnapshots.get(i).snapshot();
            }
            this.transportNodesSnapshotsStatus.execute((TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(Strings.EMPTY_ARRAY)).snapshots(snapshots).timeout(request.masterNodeTimeout()), ActionListener.wrap(nodeSnapshotStatuses -> this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> this.buildResponse(request, this.snapshotsService.currentSnapshots(request.repository(), Arrays.asList(request.snapshots())), (TransportNodesSnapshotsStatus.NodesSnapshotStatus)nodeSnapshotStatuses, (ActionListener<SnapshotsStatusResponse>)l))), listener::onFailure));
        } else {
            this.buildResponse(request, currentSnapshots, null, listener);
        }
    }

    private void buildResponse(SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses, ActionListener<SnapshotsStatusResponse> listener) {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            Map nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    SnapshotIndexShardStage stage;
                    SnapshotIndexShardStatus shardStatus;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus = shardStatues.get(objectObjectCursor.key)) != null) {
                        shardStatusBuilder.add(shardStatus);
                        continue;
                    }
                    switch (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state()));
                        }
                    }
                    SnapshotIndexShardStatus shardStatus2 = new SnapshotIndexShardStatus((ShardId)objectObjectCursor.key, stage);
                    shardStatusBuilder.add(shardStatus2);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), entry.includeGlobalState(), entry.startTime(), Math.max(this.threadPool.absoluteTimeInMillis() - entry.startTime(), 0L)));
            }
        }
        if (Strings.hasText(repositoryName = request.repository()) && request.snapshots() != null && request.snapshots().length > 0) {
            this.loadRepositoryData(request, builder, currentSnapshotNames, repositoryName, listener);
        } else {
            listener.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }
    }

    private void loadRepositoryData(SnapshotsStatusRequest request, List<SnapshotStatus> builder, Set<String> currentSnapshotNames, String repositoryName, ActionListener<SnapshotsStatusResponse> listener) {
        HashSet<String> requestedSnapshotNames = Sets.newHashSet(request.snapshots());
        StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
        this.snapshotsService.getRepositoryData(repositoryName, repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            Map matchedSnapshotIds = repositoryData.getSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
            for (String snapshotName : request.snapshots()) {
                SnapshotsInProgress.State state;
                if (currentSnapshotNames.contains(snapshotName)) continue;
                SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
                if (snapshotId == null) {
                    if (request.ignoreUnavailable()) {
                        logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                        continue;
                    }
                    throw new SnapshotMissingException(repositoryName, snapshotName);
                }
                SnapshotInfo snapshotInfo = this.snapshotsService.snapshot(repositoryName, snapshotId);
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshotInfo.state().completed()) continue;
                Map<ShardId, IndexShardSnapshotStatus> shardStatuses = this.snapshotsService.snapshotShards(repositoryName, (RepositoryData)repositoryData, snapshotInfo);
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardStatus : shardStatuses.entrySet()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue().asCopy();
                    shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                }
                switch (snapshotInfo.state()) {
                    case FAILED: {
                        state = SnapshotsInProgress.State.FAILED;
                        break;
                    }
                    case SUCCESS: 
                    case PARTIAL: {
                        state = SnapshotsInProgress.State.SUCCESS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)snapshotInfo.state()));
                    }
                }
                long startTime = snapshotInfo.startTime();
                long endTime = snapshotInfo.endTime();
                assert (endTime >= startTime || endTime == 0L && !snapshotInfo.state().completed()) : "Inconsistent timestamps found in SnapshotInfo [" + snapshotInfo + "]";
                builder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotId), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState(), startTime, (endTime == 0L ? this.threadPool.absoluteTimeInMillis() : endTime) - startTime));
            }
            listener.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }, listener::onFailure);
    }
}

