/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Comparator;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.Arrays;
import org.fest.assertions.internal.Failures;
import org.fest.util.VisibleForTesting;

public class BooleanArrays {
    private static final BooleanArrays INSTANCE = new BooleanArrays();
    private final Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static BooleanArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    BooleanArrays() {
    }

    public void assertNullOrEmpty(AssertionInfo info, boolean[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, boolean[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, boolean[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, boolean[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, boolean[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, boolean[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, boolean[] actual, boolean[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, boolean[] actual, boolean value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, boolean[] actual, boolean value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, boolean[] actual, boolean[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, boolean[] actual, boolean[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertDoesNotContain(AssertionInfo info, boolean[] actual, boolean[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, boolean[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, boolean[] actual, boolean[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, boolean[] actual, boolean[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, boolean[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, boolean[] actual, Comparator<? super Boolean> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }
}

