/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.util.Date;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.Dates;

public class ShouldBeBefore
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeBefore(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other) {
        return new ShouldBeBefore(actual, other, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = Dates.parse((String)(year + "-01-01"));
        return new ShouldBeBefore(actual, januaryTheFirstOfGivenYear, StandardComparisonStrategy.instance());
    }

    private ShouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        super("expected:<%s> to be strictly before:<%s>%s", actual, other, comparisonStrategy);
    }
}

