/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.Failures;
import org.fest.util.Dates;
import org.fest.util.VisibleForTesting;

public class DateAssert
extends AbstractAssert<DateAssert, Date> {
    @VisibleForTesting
    org.fest.assertions.internal.Dates dates = org.fest.assertions.internal.Dates.instance();
    @VisibleForTesting
    static DateFormat dateFormat = Dates.ISO_DATE_FORMAT;

    protected DateAssert(Date actual) {
        super(actual, DateAssert.class);
    }

    @Override
    public DateAssert isEqualTo(String dateAsString) {
        return (DateAssert)this.isEqualTo(DateAssert.parse(dateAsString));
    }

    @Override
    public DateAssert isNotEqualTo(String dateAsString) {
        return (DateAssert)this.isNotEqualTo(DateAssert.parse(dateAsString));
    }

    public DateAssert isIn(String ... datesAsString) {
        Object[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = DateAssert.parse(datesAsString[i]);
        }
        return (DateAssert)this.isIn(dates);
    }

    public DateAssert isInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(DateAssert.parse(dateAsString));
        }
        return (DateAssert)this.isIn(dates);
    }

    public DateAssert isNotIn(String ... datesAsString) {
        Object[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = DateAssert.parse(datesAsString[i]);
        }
        return (DateAssert)this.isNotIn(dates);
    }

    public DateAssert isNotInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(DateAssert.parse(dateAsString));
        }
        return (DateAssert)this.isNotIn(dates);
    }

    public DateAssert isBefore(Date other) {
        this.dates.assertIsBefore(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isBefore(String dateAsString) {
        return this.isBefore(DateAssert.parse(dateAsString));
    }

    public DateAssert isBeforeOrEqualsTo(Date other) {
        this.dates.assertIsBeforeOrEqualsTo(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isBeforeOrEqualsTo(String dateAsString) {
        return this.isBeforeOrEqualsTo(DateAssert.parse(dateAsString));
    }

    public DateAssert isAfter(Date other) {
        this.dates.assertIsAfter(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isAfter(String dateAsString) {
        return this.isAfter(DateAssert.parse(dateAsString));
    }

    public DateAssert isAfterOrEqualsTo(Date other) {
        this.dates.assertIsAfterOrEqualsTo(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isAfterOrEqualsTo(String dateAsString) {
        return this.isAfterOrEqualsTo(DateAssert.parse(dateAsString));
    }

    public DateAssert isBetween(Date start, Date end) {
        return this.isBetween(start, end, true, false);
    }

    public DateAssert isBetween(String start, String end) {
        return this.isBetween(DateAssert.parse(start), DateAssert.parse(end));
    }

    public DateAssert isBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return this;
    }

    public DateAssert isBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, DateAssert.parse(start), DateAssert.parse(end), inclusiveStart, inclusiveEnd);
        return this;
    }

    public DateAssert isNotBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsNotBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return this;
    }

    public DateAssert isNotBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        return this.isNotBetween(DateAssert.parse(start), DateAssert.parse(end), inclusiveStart, inclusiveEnd);
    }

    public DateAssert isNotBetween(Date start, Date end) {
        return this.isNotBetween(start, end, true, false);
    }

    public DateAssert isNotBetween(String start, String end) {
        return this.isNotBetween(DateAssert.parse(start), DateAssert.parse(end), true, false);
    }

    public DateAssert isInThePast() {
        this.dates.assertIsInThePast(this.info, (Date)this.actual);
        return this;
    }

    public DateAssert isToday() {
        this.dates.assertIsToday(this.info, (Date)this.actual);
        return this;
    }

    public DateAssert isInTheFuture() {
        this.dates.assertIsInTheFuture(this.info, (Date)this.actual);
        return this;
    }

    public DateAssert isBeforeYear(int year) {
        this.dates.assertIsBeforeYear(this.info, (Date)this.actual, year);
        return this;
    }

    public DateAssert isAfterYear(int year) {
        this.dates.assertIsAfterYear(this.info, (Date)this.actual, year);
        return this;
    }

    public DateAssert isWithinYear(int year) {
        this.dates.assertIsWithinYear(this.info, (Date)this.actual, year);
        return this;
    }

    public DateAssert isWithinMonth(int month) {
        this.dates.assertIsWithinMonth(this.info, (Date)this.actual, month);
        return this;
    }

    public DateAssert isWithinDayOfMonth(int dayOfMonth) {
        this.dates.assertIsWithinDayOfMonth(this.info, (Date)this.actual, dayOfMonth);
        return this;
    }

    public DateAssert isWithinDayOfWeek(int dayOfWeek) {
        this.dates.assertIsWithinDayOfWeek(this.info, (Date)this.actual, dayOfWeek);
        return this;
    }

    public DateAssert isWithinHourOfDay(int hourOfDay) {
        this.dates.assertIsWithinHourOfDay(this.info, (Date)this.actual, hourOfDay);
        return this;
    }

    public DateAssert isWithinMinute(int minute) {
        this.dates.assertIsWithinMinute(this.info, (Date)this.actual, minute);
        return this;
    }

    public DateAssert isWithinSecond(int second) {
        this.dates.assertIsWithinSecond(this.info, (Date)this.actual, second);
        return this;
    }

    public DateAssert isWithinMillisecond(int millisecond) {
        this.dates.assertIsWithinMillisecond(this.info, (Date)this.actual, millisecond);
        return this;
    }

    public DateAssert isInSameYearAs(Date other) {
        this.dates.assertIsInSameYearAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameYearAs(String dateAsString) {
        return this.isInSameYearAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isInSameMonthAs(Date other) {
        this.dates.assertIsInSameMonthAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameMonthAs(String dateAsString) {
        return this.isInSameMonthAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isInSameDayAs(Date other) {
        this.dates.assertIsInSameDayAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameDayAs(String dateAsString) {
        return this.isInSameDayAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isInSameHourAs(Date other) {
        this.dates.assertIsInSameHourAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameHourAs(String dateAsString) {
        return this.isInSameHourAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isInSameMinuteAs(Date other) {
        this.dates.assertIsInSameMinuteAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameMinuteAs(String dateAsString) {
        return this.isInSameMinuteAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isInSameSecondAs(Date other) {
        this.dates.assertIsInSameSecondAs(this.info, (Date)this.actual, other);
        return this;
    }

    public DateAssert isInSameSecondAs(String dateAsString) {
        return this.isInSameSecondAs(DateAssert.parse(dateAsString));
    }

    public DateAssert isCloseTo(Date other, long deltaInMilliseconds) {
        this.dates.assertIsCloseTo(this.info, (Date)this.actual, other, deltaInMilliseconds);
        return this;
    }

    public DateAssert isCloseTo(String dateAsString, long deltaInMilliseconds) {
        return this.isCloseTo(DateAssert.parse(dateAsString), deltaInMilliseconds);
    }

    public DateAssert hasTime(long timestamp) {
        this.dates.assertHasTime(this.info, (Date)this.actual, timestamp);
        return this;
    }

    public DateAssert withDateFormat(DateFormat userCustomDateFormat) {
        DateAssert.useDateFormat(userCustomDateFormat);
        return this;
    }

    public static void useDateFormat(DateFormat userCustomDateFormat) {
        if (userCustomDateFormat == null) {
            throw new NullPointerException("The given date format should not be null");
        }
        dateFormat = userCustomDateFormat;
    }

    public DateAssert withIsoDateFormat() {
        DateAssert.useIsoDateFormat();
        return this;
    }

    public static void useIsoDateFormat() {
        dateFormat = Dates.ISO_DATE_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parse(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        try {
            DateFormat dateFormat = DateAssert.dateFormat;
            synchronized (dateFormat) {
                return DateAssert.dateFormat.parse(dateAsString);
            }
        }
        catch (ParseException e) {
            throw Failures.instance().failure("Failed to parse " + dateAsString + " with date format " + dateFormat);
        }
    }

    @Override
    public DateAssert usingComparator(Comparator<? super Date> customComparator) {
        super.usingComparator(customComparator);
        this.dates = new org.fest.assertions.internal.Dates(new ComparatorBasedComparisonStrategy(customComparator));
        return (DateAssert)this.myself;
    }

    @Override
    public DateAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.dates = org.fest.assertions.internal.Dates.instance();
        return (DateAssert)this.myself;
    }
}

