/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsSqlConnection
extends DatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger(MsSqlConnection.class);
    private final ITableFilter _filter = new ExcludeTableFilter(new String[]{"dtproperties"});

    public MsSqlConnection(Connection connection, String schema) throws DatabaseUnitException {
        super(connection, schema);
        this.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", new MsSqlDataTypeFactory());
    }

    public MsSqlConnection(Connection connection) throws DatabaseUnitException {
        super(connection);
        this.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", new MsSqlDataTypeFactory());
    }

    public IDataSet createDataSet() throws SQLException {
        logger.debug("createDataSet() - start");
        IDataSet dataSet = super.createDataSet();
        return new FilteredDataSet(this._filter, dataSet);
    }

    public IDataSet createDataSet(String[] tableNames) throws SQLException, DataSetException {
        logger.debug("createDataSet(tableNames={}) - start", (Object[])tableNames);
        IDataSet dataSet = super.createDataSet(tableNames);
        return new FilteredDataSet(this._filter, dataSet);
    }
}

