/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.db2;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.DefaultMetadataHandler;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2MetadataHandler
extends DefaultMetadataHandler {
    private static final Logger logger = LoggerFactory.getLogger(Db2MetadataHandler.class);

    public boolean matches(ResultSet columnsResultSet, String catalog, String schema, String table, String column, boolean caseSensitive) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("matches(columnsResultSet={}, catalog={}, schema={}, table={}, column={}, caseSensitive={}) - start", new Object[]{columnsResultSet, catalog, schema, table, column, caseSensitive});
        }
        String catalogName = columnsResultSet.getString(1);
        String schemaName = columnsResultSet.getString(2);
        String tableName = columnsResultSet.getString(3);
        String columnName = columnsResultSet.getString(4);
        if (logger.isDebugEnabled()) {
            logger.debug("Comparing the following values using caseSensitive={} (searched<=>actual): catalog: {}<=>{} schema: {}<=>{} table: {}<=>{} column: {}<=>{}", new Object[]{caseSensitive, catalog, catalogName, schema, schemaName, table, tableName, column, columnName});
        }
        boolean areEqual = this.areEqualIgnoreBothNull(catalog, catalogName, caseSensitive) && this.areEqualIgnoreNull(schema, schemaName, caseSensitive) && this.areEqualIgnoreNull(table, tableName, caseSensitive) && this.areEqualIgnoreNull(column, columnName, caseSensitive);
        return areEqual;
    }

    private boolean areEqualIgnoreBothNull(String value1, String value2, boolean caseSensitive) {
        boolean areEqual = true;
        if (value1 != null && value2 != null && value1.equals("") && value2.equals("")) {
            areEqual = caseSensitive ? value1.equals(value2) : value1.equalsIgnoreCase(value2);
        }
        return areEqual;
    }

    private boolean areEqualIgnoreNull(String value1, String value2, boolean caseSensitive) {
        return SQLHelper.areEqualIgnoreNull(value1, value2, caseSensitive);
    }
}

