/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(UnknownDataType.class);

    UnknownDataType() {
        super("UNKNOWN", 1111, Object.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == ITable.NO_VALUE) {
            return null;
        }
        return value;
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1={}, o2={}) - start", o1, o2);
        if (this.areObjectsEqual(o1, o2)) {
            return 0;
        }
        return super.compare(UnknownDataType.asString(o1), UnknownDataType.asString(o2));
    }
}

