/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import org.dbunit.dataset.datatype.NumberDataType;
import org.dbunit.dataset.datatype.ToleratedDeltaMap;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberTolerantDataType
extends NumberDataType {
    private static final Logger logger = LoggerFactory.getLogger(NumberTolerantDataType.class);
    private static final BigDecimal C_100 = new BigDecimal("100");
    private ToleratedDeltaMap.Precision toleratedDelta;

    NumberTolerantDataType(String name, int sqlType, ToleratedDeltaMap.Precision delta) {
        super(name, sqlType);
        if (delta == null) {
            throw new NullPointerException("The parameter 'delta' must not be null");
        }
        this.toleratedDelta = delta;
    }

    public ToleratedDeltaMap.Precision getToleratedDelta() {
        return this.toleratedDelta;
    }

    protected int compareNonNulls(Object value1cast, Object value2cast) throws TypeCastException {
        logger.debug("compareNonNulls(value1={}, value2={}) - start", value1cast, value2cast);
        try {
            if (value1cast instanceof BigDecimal && value2cast instanceof BigDecimal) {
                BigDecimal bdValue1 = (BigDecimal)value1cast;
                BigDecimal bdValue2 = (BigDecimal)value2cast;
                BigDecimal diff = bdValue1.subtract(bdValue2);
                if (NumberTolerantDataType.isZero(diff)) {
                    return 0;
                }
                BigDecimal toleratedDeltaValue = this.toleratedDelta.getDelta();
                if (!this.toleratedDelta.isPercentage()) {
                    if (diff.abs().compareTo(toleratedDeltaValue) <= 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Values val1={}, val2={} differ but are within tolerated delta {}", new Object[]{bdValue1, bdValue2, toleratedDeltaValue});
                        }
                        return 0;
                    }
                    return diff.signum();
                }
                int scale = toleratedDeltaValue.scale() + 2;
                BigDecimal toleratedValue = bdValue1.multiply(toleratedDeltaValue.divide(C_100, scale, 4));
                if (diff.abs().compareTo(toleratedValue) <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Values val1={}, val2={} differ but are within tolerated delta {}", new Object[]{bdValue1, bdValue2, toleratedValue});
                    }
                    return 0;
                }
                return diff.signum();
            }
            Comparable value1 = (Comparable)value1cast;
            Comparable value2 = (Comparable)value2cast;
            return value1.compareTo(value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }

    public static final boolean isZero(BigDecimal value) {
        return value.signum() == 0;
    }
}

