/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilterTable
implements ITable {
    private final Logger logger = LoggerFactory.getLogger(ColumnFilterTable.class);
    private final ITable originalTable;
    private final ITableMetaData tableMetaData;

    public ColumnFilterTable(ITable table, IColumnFilter columnFilter) throws DataSetException {
        if (columnFilter == null) {
            throw new NullPointerException("The parameter 'columnFilter' must not be null");
        }
        if (table == null) {
            throw new NullPointerException("The parameter 'table' must not be null");
        }
        this.tableMetaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        this.originalTable = table;
    }

    public int getRowCount() {
        this.logger.debug("getRowCount() - start");
        return this.originalTable.getRowCount();
    }

    public ITableMetaData getTableMetaData() {
        this.logger.debug("getTableMetaData() - start");
        return this.tableMetaData;
    }

    public Object getValue(int row, String column) throws DataSetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        return this.originalTable.getValue(row, column);
    }

    public ITableMetaData getOriginalMetaData() {
        this.logger.debug("getOriginalMetaData() - start");
        return this.originalTable.getTableMetaData();
    }

    public String toString() {
        return this.originalTable.toString();
    }
}

