/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MainClassModuleNameExtractor {
    private final Path jdkHome;

    public MainClassModuleNameExtractor(Path jdkHome) {
        this.jdkHome = jdkHome;
    }

    public <T> Map<T, String> extract(Map<T, Path> files) throws IOException {
        Path workDir = Files.createTempDirectory("plexus-java_jpms-", new FileAttribute[0]);
        try (InputStream is = MainClassModuleNameExtractor.class.getResourceAsStream(this.getClass().getSimpleName() + ".class");){
            Path pckg = workDir.resolve(this.getClass().getPackage().getName().replace('.', '/'));
            Files.createDirectories(pckg, new FileAttribute[0]);
            Files.copy(is, pckg.resolve(this.getClass().getSimpleName() + ".class"), new CopyOption[0]);
        }
        var4_4 = null;
        try (BufferedWriter argsWriter = Files.newBufferedWriter(workDir.resolve("args"), Charset.defaultCharset(), new OpenOption[0]);){
            argsWriter.append("--class-path");
            argsWriter.newLine();
            argsWriter.append(".");
            argsWriter.newLine();
            argsWriter.append(this.getClass().getName());
            argsWriter.newLine();
            for (Path p : files.values()) {
                argsWriter.append('\"');
                argsWriter.append(p.toAbsolutePath().toString().replace("\\", "\\\\"));
                argsWriter.append('\"');
                argsWriter.newLine();
            }
        }
        catch (Throwable pckg) {
            var4_4 = pckg;
            throw pckg;
        }
        ProcessBuilder builder = new ProcessBuilder(this.jdkHome.resolve("bin/java").toAbsolutePath().toString(), "@args").directory(workDir.toFile());
        Process p = builder.start();
        Properties output = new Properties();
        InputStream is = p.getInputStream();
        Object object = null;
        try {
            output.load(is);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                MainClassModuleNameExtractor.$closeResource((Throwable)object, is);
            }
        }
        HashMap moduleNames = new HashMap(files.size());
        for (Map.Entry entry : files.entrySet()) {
            moduleNames.put(entry.getKey(), output.getProperty(((Path)entry.getValue()).toAbsolutePath().toString(), null));
        }
        try {
            Files.walkFileTree(workDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moduleNames;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        for (String path : args) {
            try {
                String moduleName = MainClassModuleNameExtractor.getModuleName(Paths.get(path, new String[0]));
                if (moduleName == null) continue;
                properties.setProperty(path, moduleName);
            }
            catch (Exception e) {
                System.err.append(e.getMessage());
            }
        }
        try {
            properties.store(System.out, "");
        }
        catch (IOException e) {
            System.exit(1);
        }
    }

    public static String getModuleName(Path modulePath) throws Exception {
        String name = null;
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
            Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{modulePath}});
            Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
            Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
            if (moduleReferences.isEmpty()) {
                return null;
            }
            Object moduleReference = moduleReferences.iterator().next();
            Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
            Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
            Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
            name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return name;
    }
}

