/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.mojo.xml.LSInputImpl;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;

public class Resolver
implements EntityResolver2,
URIResolver,
LSResourceResolver {
    private final ResourceManager locator;
    private final File baseDir;
    private final CatalogResolver resolver;
    private boolean validating;

    Resolver(File pBaseDir, List pFiles, List pUrls, ResourceManager pLocator, boolean pLogging) throws MojoExecutionException {
        int i;
        this.baseDir = pBaseDir;
        this.locator = pLocator;
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        if (pLogging) {
            System.err.println("Setting resolver verbosity to maximum.");
            manager.setVerbosity(Integer.MAX_VALUE);
        }
        this.resolver = new CatalogResolver(manager);
        for (i = 0; i < pFiles.size(); ++i) {
            File file = (File)pFiles.get(i);
            try {
                this.resolver.getCatalog().parseCatalog(file.getPath());
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog file: " + file.getPath() + ": " + e.getMessage(), (Exception)e);
            }
        }
        for (i = 0; i < pUrls.size(); ++i) {
            URL url = (URL)pUrls.get(i);
            try {
                this.resolver.getCatalog().parseCatalog(url);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog URL: " + url + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String pPublicId, String pSystemId) throws SAXException, IOException {
        InputSource source = this.resolver.resolveEntity(pPublicId, pSystemId);
        if (source != null) {
            return source;
        }
        URL url = this.resolve(pSystemId);
        if (url != null) {
            return this.asInputSource(url);
        }
        return null;
    }

    private InputSource asInputSource(URL url) throws IOException {
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toExternalForm());
        return isource;
    }

    @Override
    public Source resolve(String pHref, String pBase) throws TransformerException {
        Source source = this.resolver.resolve(pHref, pBase);
        if (source != null) {
            return source;
        }
        URL url = this.resolve(pHref);
        if (url != null) {
            try {
                return this.asSaxSource(this.asInputSource(url));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            catch (SAXException e) {
                throw new TransformerException(e);
            }
            catch (ParserConfigurationException e) {
                throw new TransformerException(e);
            }
        }
        return null;
    }

    private Source asSaxSource(InputSource isource) throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(this.validating);
        spf.setNamespaceAware(true);
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(this);
        return new SAXSource(xmlReader, isource);
    }

    private final LSInput newLSInput(InputSource pSource) {
        LSInputImpl lsInput = new LSInputImpl();
        lsInput.setByteStream(pSource.getByteStream());
        lsInput.setCharacterStream(pSource.getCharacterStream());
        lsInput.setPublicId(lsInput.getPublicId());
        lsInput.setSystemId(pSource.getSystemId());
        lsInput.setEncoding(pSource.getEncoding());
        return lsInput;
    }

    @Override
    public LSInput resolveResource(String pType, String pNamespaceURI, String pPublicId, String pSystemId, String pBaseURI) {
        InputSource isource;
        if (pPublicId != null && (isource = this.resolver.resolveEntity(pPublicId, pSystemId)) != null) {
            return this.newLSInput(isource);
        }
        isource = this.resolver.resolveEntity(pNamespaceURI, pSystemId);
        if (isource != null) {
            return this.newLSInput(isource);
        }
        URL url = this.resolve(pSystemId);
        if (url != null) {
            try {
                isource = this.asInputSource(url);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return isource == null ? null : this.newLSInput(isource);
    }

    public void setValidating(boolean pValidating) {
        this.validating = pValidating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    private URL resolveAsResource(String pResource) {
        return Thread.currentThread().getContextClassLoader().getResource(pResource);
    }

    private URL resolveAsFile(String pResource) {
        File f = new File(this.baseDir, pResource);
        if (!f.isFile() && !(f = new File(pResource)).isFile()) {
            return null;
        }
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL resolveAsURL(String pResource) {
        InputStream stream = null;
        try {
            URL url = new URL(pResource);
            stream = url.openStream();
            stream.close();
            stream = null;
            URL uRL = url;
            return uRL;
        }
        catch (IOException e) {
            URL uRL = null;
            return uRL;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public URL resolve(String pResource) {
        if (pResource == null) {
            return null;
        }
        if (pResource.startsWith("resource:")) {
            String res = pResource.substring("resource:".length());
            return this.resolveAsResource(res);
        }
        URL url = this.resolveAsResource(pResource);
        if (url == null && (url = this.resolveAsURL(pResource)) == null) {
            url = this.resolveAsFile(pResource);
        }
        try {
            return this.locator.getResource(pResource).getURL();
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String pName, String pPublicId, String pBaseURI, String pSystemId) throws SAXException, IOException {
        InputSource source = this.resolver.resolveEntity(pPublicId, pSystemId);
        if (source != null) {
            return source;
        }
        URL url = this.resolve(pSystemId);
        if (url != null) {
            return this.asInputSource(url);
        }
        return null;
    }
}

