/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.mojo.versions.utils.WagonUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVersionsHelper
implements VersionsHelper {
    private static final String TYPE_EXACT = "exact";
    private static final String TYPE_REGEX = "regex";
    private final RuleSet ruleSet;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactRepository localRepository;
    private final List remoteArtifactRepositories;
    private final List remotePluginRepositories;
    private final ArtifactFactory artifactFactory;
    private final Log log;
    private final PathTranslator pathTranslator;
    private final MavenSession mavenSession;
    private final ArtifactResolver artifactResolver;

    public DefaultVersionsHelper(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, List remoteArtifactRepositories, List remotePluginRepositories, ArtifactRepository localRepository, WagonManager wagonManager, Settings settings, String serverId, String rulesUri, Log log, MavenSession mavenSession, PathTranslator pathTranslator) throws MojoExecutionException {
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.mavenSession = mavenSession;
        this.pathTranslator = pathTranslator;
        this.ruleSet = DefaultVersionsHelper.loadRuleSet(serverId, settings, wagonManager, rulesUri, log);
        this.artifactMetadataSource = artifactMetadataSource;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remotePluginRepositories = remotePluginRepositories;
        this.log = log;
    }

    @Override
    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        List remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, remoteRepositories);
        List<IgnoreVersion> ignoredVersions = this.getIgnoredVersions(artifact);
        if (!ignoredVersions.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found ignored versions: " + this.showIgnoredVersions(ignoredVersions)));
            }
            Iterator i = versions.iterator();
            block0: while (i.hasNext()) {
                String version = ((ArtifactVersion)i.next()).toString();
                for (IgnoreVersion ignoreVersion : ignoredVersions) {
                    if (TYPE_REGEX.equals(ignoreVersion.getType())) {
                        Pattern p = Pattern.compile(ignoreVersion.getVersion());
                        if (!p.matcher(version).matches()) continue;
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                        }
                        i.remove();
                        continue block0;
                    }
                    if (!TYPE_EXACT.equals(ignoreVersion.getType()) || !version.equals(ignoreVersion.getVersion())) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                    }
                    i.remove();
                    continue block0;
                }
            }
        }
        return new ArtifactVersions(artifact, versions, this.getVersionComparator(artifact));
    }

    private List<IgnoreVersion> getIgnoredVersions(Artifact artifact) {
        ArrayList<IgnoreVersion> ret = new ArrayList<IgnoreVersion>();
        for (IgnoreVersion ignoreVersion : this.ruleSet.getIgnoreVersions()) {
            if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for global ignoreVersion[" + ignoreVersion + "] is not valid." + " Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                continue;
            }
            ret.add(ignoreVersion);
        }
        Rule rule = this.getBestFitRule(artifact.getGroupId(), artifact.getArtifactId());
        if (rule != null) {
            for (IgnoreVersion ignoreVersion : rule.getIgnoreVersions()) {
                if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                    this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for " + rule + " is not valid." + " Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                    continue;
                }
                ret.add(ignoreVersion);
            }
        }
        return ret;
    }

    private String showIgnoredVersions(List<IgnoreVersion> ignoredVersions) {
        StringBuilder buf = new StringBuilder();
        Iterator<IgnoreVersion> iterator = ignoredVersions.iterator();
        while (iterator.hasNext()) {
            IgnoreVersion ignoreVersion = iterator.next();
            buf.append(ignoreVersion);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException, ArtifactNotFoundException {
        List remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        this.artifactResolver.resolve(artifact, remoteRepositories, this.localRepository);
    }

    @Override
    public VersionComparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    @Override
    public VersionComparator getVersionComparator(String groupId, String artifactId) {
        Rule rule = this.getBestFitRule(groupId, artifactId);
        String comparisonMethod = rule == null ? this.ruleSet.getComparisonMethod() : rule.getComparisonMethod();
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    protected Rule getBestFitRule(String groupId, String artifactId) {
        Rule bestFit = null;
        List<Rule> rules = this.ruleSet.getRules();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        for (Rule rule : rules) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            bestFit = rule;
        }
        return bestFit;
    }

    /*
     * Exception decompiling
     */
    private static RuleSet getRuleSet(Wagon wagon, String remoteURI) throws IOException, AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet loadRuleSet(String serverId, Settings settings, WagonManager wagonManager, String rulesUri, Log logger) throws MojoExecutionException {
        RuleSet ruleSet = new RuleSet();
        if (rulesUri != null && rulesUri.trim().length() != 0) {
            try {
                String fileUri;
                String baseUri;
                int split = rulesUri.lastIndexOf(47);
                if (split != -1) {
                    baseUri = rulesUri.substring(0, split) + '/';
                    fileUri = split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "";
                } else {
                    baseUri = rulesUri;
                    fileUri = "";
                }
                try {
                    Wagon wagon = WagonUtils.createWagon(serverId, baseUri, wagonManager, settings, logger);
                    try {
                        logger.debug((CharSequence)("Trying to load ruleset from file \"" + fileUri + "\" in " + baseUri));
                        RuleSet loaded = DefaultVersionsHelper.getRuleSet(wagon, fileUri);
                        ruleSet.setRules(loaded.getRules());
                        ruleSet.setIgnoreVersions(loaded.getIgnoreVersions());
                        logger.debug((CharSequence)"Rule set loaded");
                    }
                    finally {
                        if (wagon != null) {
                            try {
                                wagon.disconnect();
                            }
                            catch (ConnectionException e) {
                                logger.warn((CharSequence)"Could not disconnect wagon!", (Throwable)e);
                            }
                        }
                    }
                }
                catch (TransferFailedException e) {
                    throw new MojoExecutionException("Could not transfer rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthorizationException e) {
                    throw new MojoExecutionException("Authorization failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (ResourceDoesNotExistException e) {
                    throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthenticationException e) {
                    throw new MojoExecutionException("Authentication failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (UnsupportedProtocolException e) {
                    throw new MojoExecutionException("Unsupported protocol for " + rulesUri, (Exception)((Object)e));
                }
                catch (ConnectionException e) {
                    throw new MojoExecutionException("Could not establish connection to " + rulesUri, (Exception)((Object)e));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)e);
            }
        }
        return ruleSet;
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope) {
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope);
    }

    @Override
    public Artifact createDependencyArtifact(Dependency dependency) throws InvalidVersionSpecificationException {
        return this.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion() == null ? VersionRange.createFromVersionSpec((String)"[0,]") : VersionRange.createFromVersionSpec((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional());
    }

    @Override
    public Set<Artifact> extractArtifacts(Collection<MavenProject> mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (MavenProject project : mavenProjects) {
            result.add(project.getArtifact());
        }
        return result;
    }

    @Override
    public ArtifactVersion createArtifactVersion(String version) {
        return new DefaultArtifactVersion(version);
    }

    @Override
    public ArtifactVersions lookupArtifactUpdates(Artifact artifact, Boolean allowSnapshots, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactVersions artifactVersions = this.lookupArtifactVersions(artifact, usePluginRepositories);
        artifactVersions.setIncludeSnapshots(Boolean.TRUE.equals(allowSnapshots));
        return artifactVersions;
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Set dependencies, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        TreeMap<Dependency, ArtifactVersions> dependencyUpdates = new TreeMap<Dependency, ArtifactVersions>(new DependencyComparator());
        for (Object dependency1 : dependencies) {
            Dependency dependency = (Dependency)dependency1;
            ArtifactVersions details = this.lookupDependencyUpdates(dependency, usePluginRepositories);
            dependencyUpdates.put(dependency, details);
        }
        return dependencyUpdates;
    }

    @Override
    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()) + " for updates newer than " + dependency.getVersion()));
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        return this.lookupArtifactVersions(this.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope()), usePluginRepositories);
    }

    @Override
    public Map<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Set<Plugin> plugins, Boolean allowSnapshots) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        TreeMap<Plugin, PluginUpdatesDetails> pluginUpdates = new TreeMap<Plugin, PluginUpdatesDetails>(new PluginComparator());
        for (Plugin plugin : plugins) {
            PluginUpdatesDetails details = this.lookupPluginUpdates(plugin, allowSnapshots);
            pluginUpdates.put(plugin, details);
        }
        return pluginUpdates;
    }

    @Override
    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, Boolean allowSnapshots) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        String version = plugin.getVersion();
        version = version == null ? "LATEST" : version;
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId()) + " for updates newer than " + version));
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        boolean includeSnapshots = Boolean.TRUE.equals(allowSnapshots);
        ArtifactVersions pluginArtifactVersions = this.lookupArtifactVersions(this.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange), true);
        TreeSet<Dependency> pluginDependencies = new TreeSet<Dependency>(new DependencyComparator());
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map<Dependency, ArtifactVersions> pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies, false);
        return new PluginUpdatesDetails(pluginArtifactVersions, pluginDependencyDetails, includeSnapshots);
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator(MavenProject project) {
        return new VersionsExpressionEvaluator(this.mavenSession, this.pathTranslator, project);
    }

    @Override
    public Map<Property, PropertyVersions> getVersionPropertiesMap(MavenProject project, Property[] propertyDefinitions, String includeProperties, String excludeProperties, boolean autoLinkItems) throws MojoExecutionException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (propertyDefinitions != null) {
            for (Property propertyDefinition : propertyDefinitions) {
                properties.put(propertyDefinition.getName(), propertyDefinition);
            }
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (autoLinkItems) {
            PropertyVersionsBuilder[] propertyVersionsBuilders;
            try {
                propertyVersionsBuilders = PomHelper.getPropertyVersionsBuilders(this, project);
            }
            catch (ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (PropertyVersionsBuilder propertyVersionsBuilder : propertyVersionsBuilders) {
                String name = propertyVersionsBuilder.getName();
                builders.put(name, propertyVersionsBuilder);
                if (properties.containsKey(name)) continue;
                Property value = new Property(name);
                this.getLog().debug((CharSequence)("Property ${" + name + "}: Adding inferred version range of " + propertyVersionsBuilder.getVersionRange()));
                value.setVersion(propertyVersionsBuilder.getVersionRange());
                properties.put(name, value);
            }
        }
        this.getLog().debug((CharSequence)"Searching for properties associated with builders");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            if (includeProperties != null && !includeProperties.contains(property.getName())) {
                this.getLog().debug((CharSequence)("Skipping property ${" + property.getName() + "}"));
                i.remove();
                continue;
            }
            if (excludeProperties == null || !excludeProperties.contains(property.getName())) continue;
            this.getLog().debug((CharSequence)("Ignoring property ${" + property.getName() + "}"));
            i.remove();
        }
        i = properties.values().iterator();
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        while (i.hasNext()) {
            Dependency[] dependencies;
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(property.getName());
            if (builder == null || !builder.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not " + "associated with any dependency..."));
                builder = new PropertyVersionsBuilder(null, property.getName(), this);
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                builder.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    try {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependency));
                        builder.addAssociation(this.createDependencyArtifact(dependency), false);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                    }
                }
            }
            try {
                PropertyVersions versions = builder.newPropertyVersions();
                if (property.isAutoLinkDependencies() && StringUtils.isEmpty((String)property.getVersion()) && !StringUtils.isEmpty((String)builder.getVersionRange())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding inferred version range of " + builder.getVersionRange()));
                    property.setVersion(builder.getVersionRange());
                }
                versions.setCurrentVersion(project.getProperties().getProperty(property.getName()));
                propertyVersions.put(property, versions);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return propertyVersions;
    }
}

