/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tidy.PomTidy;
import org.codehaus.mojo.tidy.Utils;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
public class CheckMojo
extends AbstractMojo {
    private static final PomTidy POM_TIDY = new PomTidy();
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String pom = Utils.readXmlFile(this.project.getFile());
            String tidyPom = POM_TIDY.tidy(pom);
            if (!pom.equals(tidyPom)) {
                throw new MojoFailureException("The POM violates the code style. Please format it by running `mvn tidy:pom`.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

