/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractPreprocessorMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;

public class JJTreeMojo
extends AbstractPreprocessorMojo {
    private String jdkVersion;
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private String nodeClass;
    private String nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean isStatic;
    private Boolean trackTokens;
    private Boolean visitor;
    private String visitorDataType;
    private String visitorReturnType;
    private String visitorException;
    private File sourceDirectory;
    private File outputDirectory;
    private File timestampDirectory;
    private int staleMillis;
    private String[] includes;
    private String[] excludes;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jjt", "**/*.JJT"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected File getTimestampDirectory() {
        return this.timestampDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        File nodeDirectory = nodePackageName != null ? new File(nodePackageName.replace('.', File.separatorChar)) : new File(grammarInfo.getParserDirectory());
        nodeDirectory = new File(this.getOutputDirectory(), nodeDirectory.getPath());
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(nodeDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        this.createTimestamp(grammarInfo);
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setJdkVersion(this.jdkVersion);
        jjtree.setStatic(this.isStatic);
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeClass(this.nodeClass);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setTrackTokens(this.trackTokens);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorDataType(this.visitorDataType);
        jjtree.setVisitorReturnType(this.visitorReturnType);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }

    protected void addCompileSourceRoot() {
    }
}

