/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.exporter;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.hibernate3.ExporterMojo;
import org.codehaus.mojo.hibernate3.HibernateExporterMojo;
import org.codehaus.mojo.hibernate3.HibernateUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.Exporter;

public class Hbm2DDLExporterMojo
extends HibernateExporterMojo {
    public Hbm2DDLExporterMojo() {
        this.addDefaultComponent("target/hibernate3/sql", "configuration", false);
        this.addDefaultComponent("target/hibernate3/sql", "annotationconfiguration", true);
    }

    public String getName() {
        return "hbm2ddl";
    }

    protected Exporter createExporter() {
        throw new IllegalStateException("Should not call create exporter on hbm2ddl");
    }

    protected void doExecute() throws MojoExecutionException {
        boolean scriptToConsole = this.getComponentProperty("console", true);
        boolean exportToDatabase = this.getComponentProperty("export", true);
        boolean haltOnError = this.getComponentProperty("haltonerror", false);
        boolean drop = this.getComponentProperty("drop", false);
        boolean create = this.getComponentProperty("create", true);
        String implementation = this.getComponentProperty("implementation", this.getComponent().getImplementation());
        Configuration configuration = this.getComponentConfiguration(implementation).getConfiguration((ExporterMojo)this);
        if (this.getComponentProperty("update", false)) {
            SchemaUpdate update = new SchemaUpdate(configuration);
            update.execute(scriptToConsole, exportToDatabase);
        } else {
            SchemaExport export = new SchemaExport(configuration);
            export.setDelimiter(this.getComponentProperty("delimiter", ";"));
            export.setHaltOnError(haltOnError);
            export.setFormat(this.getComponentProperty("format", false));
            String outputFilename = this.getComponentProperty("outputfilename");
            if (outputFilename != null) {
                File outputFile = HibernateUtils.prepareFile((File)new File(this.getProject().getBasedir(), this.getComponent().getOutputDirectory()), (String)outputFilename, (String)"outputfilename");
                export.setOutputFile(outputFile.toString());
            }
            if (drop && create) {
                export.create(scriptToConsole, exportToDatabase);
            } else {
                export.execute(scriptToConsole, exportToDatabase, drop, create);
            }
            if (export.getExceptions().size() > 0) {
                Iterator iterator = export.getExceptions().iterator();
                int cnt = 1;
                this.getLog().warn((CharSequence)(export.getExceptions().size() + " errors occurred while performing <hbm2ddl>."));
                while (iterator.hasNext()) {
                    this.getLog().error((CharSequence)("Error #" + cnt + ": " + iterator.next().toString()));
                }
                if (haltOnError) {
                    throw new MojoExecutionException("Errors while performing <hbm2ddl>");
                }
            }
        }
    }
}

