/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.flatten.AbstractFlattenMojo;
import org.codehaus.mojo.flatten.Dependencies;
import org.codehaus.mojo.flatten.ElementHandling;
import org.codehaus.mojo.flatten.FlattenDescriptor;
import org.codehaus.mojo.flatten.FlattenMode;
import org.codehaus.mojo.flatten.LoggingModelProblemCollector;
import org.codehaus.mojo.flatten.PomProperty;
import org.codehaus.mojo.flatten.model.resolution.FlattenModelResolver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="flatten", requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", requiresDependencyCollection=ResolutionScope.RUNTIME)
public class FlattenMojo
extends AbstractFlattenMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="updatePomFile")
    private Boolean updatePomFile;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="false")
    private Boolean embedBuildProfileDependencies;
    @Parameter(defaultValue="${mojo}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(required=false)
    private FlattenDescriptor pomElements;
    @Parameter(required=false)
    private FlattenMode flattenMode;
    @Component
    private ArtifactFactory artifactFactory;
    @Component(role=ModelInterpolator.class)
    private ModelInterpolator modelInterpolator;
    @Component
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating flattened POM of project " + this.project.getId() + "..."));
        File originalPomFile = this.project.getFile();
        Model flattenedPom = this.createFlattenedPom(originalPomFile);
        String headerComment = this.extractHeaderComment(originalPomFile);
        File flattenedPomFile = this.getFlattenedPomFile();
        this.writePom(flattenedPom, flattenedPomFile, headerComment);
        if (this.isUpdatePomFile()) {
            this.project.setFile(flattenedPomFile);
        }
    }

    protected String extractHeaderComment(File xmlFile) throws MojoExecutionException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SaxHeaderCommentHandler handler = new SaxHeaderCommentHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(xmlFile, (DefaultHandler)handler);
            return handler.getHeaderComment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse XML from " + xmlFile, e);
        }
    }

    protected void writePom(Model pom, File pomFile, String headerComment) throws MojoExecutionException {
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter stringWriter = new StringWriter(4096);
        try {
            pomWriter.write((Writer)stringWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        StringBuffer buffer = stringWriter.getBuffer();
        if (!StringUtils.isEmpty((String)headerComment)) {
            int projectStartIndex = buffer.indexOf("<project");
            if (projectStartIndex >= 0) {
                buffer.insert(projectStartIndex, "<!--" + headerComment + "-->\n");
            } else {
                this.getLog().warn((CharSequence)"POM XML post-processing failed: no project tag found!");
            }
        }
        this.writeStringToFile(buffer.toString(), pomFile, pom.getModelEncoding());
    }

    protected void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        FileOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            outStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outStream, encoding);
            writer.write(data);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                IOUtil.close((OutputStream)outStream);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        IOUtil.close((OutputStream)outStream);
    }

    protected Model createFlattenedPom(File pomFile) throws MojoExecutionException, MojoFailureException {
        ModelBuildingRequest buildingRequest = this.createModelBuildingRequest(pomFile);
        Model effectivePom = FlattenMojo.createEffectivePom(buildingRequest, this.isEmbedBuildProfileDependencies());
        Model flattenedPom = new Model();
        String modelEncoding = effectivePom.getModelEncoding();
        if (StringUtils.isEmpty((String)modelEncoding)) {
            modelEncoding = "UTF-8";
        }
        flattenedPom.setModelEncoding(modelEncoding);
        Model cleanPom = this.createCleanPom(effectivePom);
        FlattenDescriptor descriptor = this.getFlattenDescriptor();
        Model originalPom = this.project.getOriginalModel();
        Model resolvedPom = this.project.getModel();
        Model interpolatedPom = this.createResolvedPom(buildingRequest);
        for (PomProperty<?> property : PomProperty.getPomProperties()) {
            if (!property.isElement()) continue;
            Model sourceModel = this.getSourceModel(descriptor, property, effectivePom, originalPom, resolvedPom, interpolatedPom, cleanPom);
            if (sourceModel == null) {
                if (!property.isRequired()) continue;
                throw new MojoFailureException("Property " + property.getName() + " is required and can not be removed!");
            }
            property.copy(sourceModel, flattenedPom);
        }
        return flattenedPom;
    }

    private Model createResolvedPom(ModelBuildingRequest buildingRequest) {
        LoggingModelProblemCollector problems = new LoggingModelProblemCollector(this.getLog());
        Model originalModel = this.project.getOriginalModel().clone();
        return this.modelInterpolator.interpolateModel(originalModel, this.project.getModel().getProjectDirectory(), buildingRequest, (ModelProblemCollector)problems);
    }

    protected Model createCleanPom(Model effectivePom) {
        Model cleanPom = new Model();
        cleanPom.setGroupId(effectivePom.getGroupId());
        cleanPom.setArtifactId(effectivePom.getArtifactId());
        cleanPom.setVersion(effectivePom.getVersion());
        cleanPom.setPackaging(effectivePom.getPackaging());
        cleanPom.setLicenses(effectivePom.getLicenses());
        cleanPom.setModelVersion("4.0.0");
        Build build = effectivePom.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                Build cleanBuild = cleanPom.getBuild();
                if (cleanBuild == null) {
                    cleanBuild = new Build();
                    cleanPom.setBuild(cleanBuild);
                }
                Plugin cleanPlugin = new Plugin();
                cleanPlugin.setGroupId(plugin.getGroupId());
                cleanPlugin.setArtifactId(plugin.getArtifactId());
                cleanPlugin.setVersion(plugin.getVersion());
                cleanPlugin.setExtensions(true);
                cleanBuild.addPlugin(cleanPlugin);
            }
        }
        for (Profile profile : effectivePom.getProfiles()) {
            if (this.isEmbedBuildProfileDependencies() && FlattenMojo.isBuildTimeDriven(profile.getActivation()) || this.isEmpty(profile.getDependencies()) && this.isEmpty(profile.getRepositories())) continue;
            Profile strippedProfile = new Profile();
            strippedProfile.setId(profile.getId());
            strippedProfile.setActivation(profile.getActivation());
            strippedProfile.setDependencies(profile.getDependencies());
            strippedProfile.setRepositories(profile.getRepositories());
            cleanPom.addProfile(strippedProfile);
        }
        List<Dependency> dependencies = this.createFlattenedDependencies(effectivePom);
        cleanPom.setDependencies(dependencies);
        return cleanPom;
    }

    private Model getSourceModel(FlattenDescriptor descriptor, PomProperty<?> property, Model effectivePom, Model originalPom, Model resolvedPom, Model interpolatedPom, Model cleanPom) {
        ElementHandling handling = descriptor.getHandling(property);
        this.getLog().debug((CharSequence)("Property " + property.getName() + " will be handled using " + (Object)((Object)handling) + " in flattened POM."));
        switch (handling) {
            case expand: {
                return effectivePom;
            }
            case keep: {
                return originalPom;
            }
            case resolve: {
                return resolvedPom;
            }
            case interpolate: {
                return interpolatedPom;
            }
            case flatten: {
                return cleanPom;
            }
            case remove: {
                return null;
            }
        }
        throw new IllegalStateException(handling.toString());
    }

    protected static List<Repository> createFlattenedRepositories(List<Repository> repositories) {
        if (repositories != null) {
            ArrayList<Repository> flattenedRepositories = new ArrayList<Repository>(repositories.size());
            for (Repository repo : repositories) {
                if (FlattenMojo.isCentralRepositoryFromSuperPom(repo)) continue;
                flattenedRepositories.add(repo);
            }
            return flattenedRepositories;
        }
        return repositories;
    }

    private FlattenDescriptor getFlattenDescriptor() throws MojoFailureException {
        FlattenDescriptor descriptor = this.pomElements;
        if (descriptor == null) {
            FlattenMode mode = this.flattenMode;
            if (mode == null) {
                mode = FlattenMode.defaults;
            } else if (this.flattenMode == FlattenMode.minimum) {
                this.getLog().warn((CharSequence)("FlattenMode " + (Object)((Object)FlattenMode.minimum) + " is deprecated!"));
            }
            descriptor = mode.getDescriptor();
            if ("maven-plugin".equals(this.project.getPackaging())) {
                descriptor.setPrerequisites(ElementHandling.expand);
            }
        } else {
            if (descriptor.isEmpty()) {
                Xpp3Dom rawDescriptor = this.mojoExecution.getConfiguration().getChild("pomElements");
                descriptor = new FlattenDescriptor(rawDescriptor);
            }
            if (this.flattenMode != null) {
                descriptor = descriptor.merge(this.flattenMode.getDescriptor());
            }
        }
        return descriptor;
    }

    private static boolean isCentralRepositoryFromSuperPom(Repository repo) {
        RepositoryPolicy snapshots;
        return repo != null && "central".equals(repo.getId()) && (snapshots = repo.getSnapshots()) != null && !snapshots.isEnabled();
    }

    private ModelBuildingRequest createModelBuildingRequest(File pomFile) {
        FlattenModelResolver resolver = new FlattenModelResolver(this.localRepository, this.artifactFactory);
        Properties userProperties = this.session.getUserProperties();
        DefaultModelBuildingRequest buildingRequest = new DefaultModelBuildingRequest().setUserProperties(userProperties).setSystemProperties(System.getProperties()).setPomFile(pomFile).setModelResolver((ModelResolver)resolver);
        return buildingRequest;
    }

    protected static Model createEffectivePom(ModelBuildingRequest buildingRequest, final boolean embedBuildProfileDependencies) throws MojoExecutionException {
        ModelBuildingResult buildingResult;
        try {
            ProfileInjector profileInjector = new ProfileInjector(){

                public void injectProfile(Model model, Profile profile, ModelBuildingRequest request, ModelProblemCollector problems) {
                }
            };
            ProfileSelector profileSelector = new ProfileSelector(){

                public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
                    ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
                    for (Profile profile : profiles) {
                        Activation activation = profile.getActivation();
                        if (embedBuildProfileDependencies && !FlattenMojo.isBuildTimeDriven(activation)) continue;
                        activeProfiles.add(profile);
                    }
                    return activeProfiles;
                }
            };
            DefaultModelBuilder defaultModelBuilder = new DefaultModelBuilderFactory().newInstance();
            defaultModelBuilder.setProfileInjector(profileInjector).setProfileSelector(profileSelector);
            buildingResult = defaultModelBuilder.build(buildingRequest);
        }
        catch (ModelBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Model effectivePom = buildingResult.getEffectiveModel();
        effectivePom.setRepositories(FlattenMojo.createFlattenedRepositories(effectivePom.getRepositories()));
        return effectivePom;
    }

    private boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public boolean isEmbedBuildProfileDependencies() {
        return this.embedBuildProfileDependencies;
    }

    protected static boolean isBuildTimeDriven(Activation activation) {
        if (activation == null) {
            return true;
        }
        return StringUtils.isEmpty((String)activation.getJdk()) && activation.getOs() == null;
    }

    protected List<Dependency> createFlattenedDependencies(Model effectiveModel) {
        ArrayList<Dependency> flattenedDependencies = new ArrayList<Dependency>();
        this.createFlattenedDependencies(effectiveModel, flattenedDependencies);
        if (this.isEmbedBuildProfileDependencies()) {
            Model projectModel = this.project.getModel();
            Dependencies modelDependencies = new Dependencies();
            modelDependencies.addAll(projectModel.getDependencies());
            for (Profile profile : projectModel.getProfiles()) {
                if (!FlattenMojo.isBuildTimeDriven(profile.getActivation())) continue;
                List profileDependencies = profile.getDependencies();
                for (Dependency profileDependency : profileDependencies) {
                    if (!modelDependencies.contains(profileDependency)) continue;
                    flattenedDependencies.add(profileDependency);
                }
            }
            this.getLog().debug((CharSequence)("Resolved " + flattenedDependencies.size() + " dependency/-ies for flattened POM."));
        }
        return flattenedDependencies;
    }

    protected void createFlattenedDependencies(Model effectiveModel, List<Dependency> flattenedDependencies) {
        this.getLog().debug((CharSequence)("Resolving dependencies of " + effectiveModel.getId()));
        List projectDependencies = effectiveModel.getDependencies();
        for (Dependency projectDependency : projectDependencies) {
            Dependency flattenedDependency = this.createFlattenedDependency(projectDependency);
            if (flattenedDependency == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    protected Dependency createFlattenedDependency(Dependency projectDependency) {
        return "test".equals(projectDependency.getScope()) ? null : projectDependency;
    }

    public boolean isUpdatePomFile() {
        if (this.updatePomFile == null) {
            if (this.flattenMode == FlattenMode.bom) {
                return true;
            }
            return !this.project.getPackaging().equals("pom");
        }
        return this.updatePomFile;
    }

    private class SaxHeaderCommentHandler
    extends DefaultHandler2 {
        private boolean rootTagSeen = false;
        private String headerComment;

        public String getHeaderComment() {
            return this.headerComment;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.rootTagSeen) {
                if (this.headerComment == null) {
                    this.headerComment = new String(ch, start, length);
                } else {
                    FlattenMojo.this.getLog().warn((CharSequence)"Ignoring multiple XML header comment!");
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.rootTagSeen = true;
        }
    }
}

