/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.yaml.swapper;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlDatabaseDiscoveryRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlDatabaseDiscoveryRuleConfiguration, DatabaseDiscoveryRuleConfiguration> {
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlDatabaseDiscoveryRuleConfiguration swapToYamlConfiguration(DatabaseDiscoveryRuleConfiguration data) {
        YamlDatabaseDiscoveryRuleConfiguration result = new YamlDatabaseDiscoveryRuleConfiguration();
        result.setDataSources(data.getDataSources().stream().collect(Collectors.toMap(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName, this::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        if (null != data.getDiscoveryHeartbeats()) {
            data.getDiscoveryHeartbeats().forEach((key, value) -> result.getDiscoveryHeartbeats().put((String)key, this.swapToYamlConfiguration((DatabaseDiscoveryHeartBeatConfiguration)value)));
        }
        if (null != data.getDiscoveryTypes()) {
            data.getDiscoveryTypes().forEach((key, value) -> result.getDiscoveryTypes().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
        return result;
    }

    private YamlDatabaseDiscoveryDataSourceRuleConfiguration swapToYamlConfiguration(DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfig) {
        YamlDatabaseDiscoveryDataSourceRuleConfiguration result = new YamlDatabaseDiscoveryDataSourceRuleConfiguration();
        result.setDataSourceNames(dataSourceRuleConfig.getDataSourceNames());
        result.setDiscoveryHeartbeatName(dataSourceRuleConfig.getDiscoveryHeartbeatName());
        result.setDiscoveryTypeName(dataSourceRuleConfig.getDiscoveryTypeName());
        return result;
    }

    private YamlDatabaseDiscoveryHeartBeatConfiguration swapToYamlConfiguration(DatabaseDiscoveryHeartBeatConfiguration heartBeatRuleConfig) {
        YamlDatabaseDiscoveryHeartBeatConfiguration result = new YamlDatabaseDiscoveryHeartBeatConfiguration();
        result.setProps(heartBeatRuleConfig.getProps());
        return result;
    }

    public DatabaseDiscoveryRuleConfiguration swapToObject(YamlDatabaseDiscoveryRuleConfiguration yamlConfig) {
        LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources = new LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration>();
        for (Map.Entry<String, YamlDatabaseDiscoveryDataSourceRuleConfiguration> entry : yamlConfig.getDataSources().entrySet()) {
            dataSources.add(this.swapToObject(entry.getKey(), entry.getValue()));
        }
        LinkedHashMap heartBeats = new LinkedHashMap(yamlConfig.getDiscoveryHeartbeats().entrySet().size(), 1.0f);
        if (null != yamlConfig.getDiscoveryHeartbeats()) {
            yamlConfig.getDiscoveryHeartbeats().forEach((key, value) -> heartBeats.put(key, this.swapToObject((YamlDatabaseDiscoveryHeartBeatConfiguration)value)));
        }
        LinkedHashMap haTypes = new LinkedHashMap(yamlConfig.getDiscoveryTypes().entrySet().size(), 1.0f);
        if (null != yamlConfig.getDiscoveryTypes()) {
            yamlConfig.getDiscoveryTypes().forEach((key, value) -> haTypes.put(key, this.algorithmSwapper.swapToObject(value)));
        }
        return new DatabaseDiscoveryRuleConfiguration(dataSources, heartBeats, haTypes);
    }

    private DatabaseDiscoveryDataSourceRuleConfiguration swapToObject(String name, YamlDatabaseDiscoveryDataSourceRuleConfiguration yamlDataSourceRuleConfig) {
        return new DatabaseDiscoveryDataSourceRuleConfiguration(name, yamlDataSourceRuleConfig.getDataSourceNames(), yamlDataSourceRuleConfig.getDiscoveryHeartbeatName(), yamlDataSourceRuleConfig.getDiscoveryTypeName());
    }

    private DatabaseDiscoveryHeartBeatConfiguration swapToObject(YamlDatabaseDiscoveryHeartBeatConfiguration yamlHeartbeatRuleConfig) {
        return new DatabaseDiscoveryHeartBeatConfiguration(yamlHeartbeatRuleConfig.getProps());
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getTypeClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "DB_DISCOVERY";
    }

    public int getOrder() {
        return 40;
    }
}

