/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.yaml.swapper;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlDatabaseDiscoveryRuleAlgorithmProviderConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlDatabaseDiscoveryRuleConfiguration, AlgorithmProvidedDatabaseDiscoveryRuleConfiguration> {
    public YamlDatabaseDiscoveryRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedDatabaseDiscoveryRuleConfiguration data) {
        YamlDatabaseDiscoveryRuleConfiguration result = new YamlDatabaseDiscoveryRuleConfiguration();
        result.setDataSources(data.getDataSources().stream().collect(Collectors.toMap(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName, this::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        if (null != data.getDiscoveryHeartbeats()) {
            data.getDiscoveryHeartbeats().forEach((key, value) -> result.getDiscoveryHeartbeats().put((String)key, this.swapToYamlConfiguration((DatabaseDiscoveryHeartBeatConfiguration)value)));
        }
        if (null != data.getDiscoveryTypes()) {
            data.getDiscoveryTypes().forEach((key, value) -> result.getDiscoveryTypes().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
        }
        return result;
    }

    private YamlDatabaseDiscoveryDataSourceRuleConfiguration swapToYamlConfiguration(DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfig) {
        YamlDatabaseDiscoveryDataSourceRuleConfiguration result = new YamlDatabaseDiscoveryDataSourceRuleConfiguration();
        result.setDataSourceNames(dataSourceRuleConfig.getDataSourceNames());
        result.setDiscoveryHeartbeatName(dataSourceRuleConfig.getDiscoveryHeartbeatName());
        result.setDiscoveryTypeName(dataSourceRuleConfig.getDiscoveryTypeName());
        return result;
    }

    private YamlDatabaseDiscoveryHeartBeatConfiguration swapToYamlConfiguration(DatabaseDiscoveryHeartBeatConfiguration heartBeatConfig) {
        YamlDatabaseDiscoveryHeartBeatConfiguration result = new YamlDatabaseDiscoveryHeartBeatConfiguration();
        result.setProps(heartBeatConfig.getProps());
        return result;
    }

    public AlgorithmProvidedDatabaseDiscoveryRuleConfiguration swapToObject(YamlDatabaseDiscoveryRuleConfiguration yamlConfig) {
        LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources = new LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration>();
        for (Map.Entry<String, YamlDatabaseDiscoveryDataSourceRuleConfiguration> entry : yamlConfig.getDataSources().entrySet()) {
            dataSources.add(this.swapToObject(entry.getKey(), entry.getValue()));
        }
        LinkedHashMap<String, DatabaseDiscoveryHeartBeatConfiguration> heartBeats = new LinkedHashMap<String, DatabaseDiscoveryHeartBeatConfiguration>(yamlConfig.getDiscoveryHeartbeats().entrySet().size(), 1.0f);
        if (null != yamlConfig.getDiscoveryHeartbeats()) {
            yamlConfig.getDiscoveryHeartbeats().forEach((key, value) -> heartBeats.put((String)key, this.swapToObject((YamlDatabaseDiscoveryHeartBeatConfiguration)value)));
        }
        AlgorithmProvidedDatabaseDiscoveryRuleConfiguration ruleConfig = new AlgorithmProvidedDatabaseDiscoveryRuleConfiguration();
        ruleConfig.setDataSources(dataSources);
        ruleConfig.setDiscoveryHeartbeats(heartBeats);
        return ruleConfig;
    }

    private DatabaseDiscoveryDataSourceRuleConfiguration swapToObject(String name, YamlDatabaseDiscoveryDataSourceRuleConfiguration yamlDataSourceRuleConfig) {
        return new DatabaseDiscoveryDataSourceRuleConfiguration(name, yamlDataSourceRuleConfig.getDataSourceNames(), yamlDataSourceRuleConfig.getDiscoveryHeartbeatName(), yamlDataSourceRuleConfig.getDiscoveryTypeName());
    }

    private DatabaseDiscoveryHeartBeatConfiguration swapToObject(YamlDatabaseDiscoveryHeartBeatConfiguration yamlHeartBeatConfig) {
        return new DatabaseDiscoveryHeartBeatConfiguration(yamlHeartBeatConfig.getProps());
    }

    public Class<AlgorithmProvidedDatabaseDiscoveryRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedDatabaseDiscoveryRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "DB_DISCOVERY";
    }

    public int getOrder() {
        return 41;
    }
}

