/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryRule;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRuleBuilder;

public final class DatabaseDiscoveryRuleBuilder
implements DatabaseRuleBuilder<DatabaseDiscoveryRuleConfiguration> {
    public DatabaseDiscoveryRule build(DatabaseDiscoveryRuleConfiguration config, String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, InstanceContext instanceContext) {
        HashMap<String, DataSource> realDataSourceMap = new HashMap<String, DataSource>();
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : config.getDataSources()) {
            for (String datasourceName : each.getDataSourceNames()) {
                realDataSourceMap.put(datasourceName, dataSources.get(datasourceName));
            }
        }
        return new DatabaseDiscoveryRule(databaseName, realDataSourceMap, config, instanceContext);
    }

    public int getOrder() {
        return 40;
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getTypeClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }
}

