/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.algorithm.DatabaseDiscoveryEngine;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.dbdiscovery.heartbeat.HeartbeatJob;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryDataSourceRule;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DynamicDataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;
import org.apache.shardingsphere.infra.schedule.CronJob;
import org.apache.shardingsphere.infra.schedule.ScheduleContext;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.StorageNodeDataSourceChangedEvent;
import org.apache.shardingsphere.schedule.core.ScheduleContextFactory;

public final class DatabaseDiscoveryRule
implements DatabaseRule,
DataSourceContainedRule,
DynamicDataSourceContainedRule,
ExportableRule {
    private final RuleConfiguration configuration;
    private final String databaseName;
    private final Map<String, DataSource> dataSourceMap;
    private final Map<String, DatabaseDiscoveryProviderAlgorithm> discoveryTypes;
    private final Map<String, DatabaseDiscoveryDataSourceRule> dataSourceRules;
    private final InstanceContext instanceContext;
    private final ScheduleContext scheduleContext;

    public DatabaseDiscoveryRule(String databaseName, Map<String, DataSource> dataSourceMap, DatabaseDiscoveryRuleConfiguration ruleConfig, InstanceContext instanceContext) {
        this.configuration = ruleConfig;
        this.databaseName = databaseName;
        this.dataSourceMap = dataSourceMap;
        this.instanceContext = instanceContext;
        this.scheduleContext = ScheduleContextFactory.newInstance((ModeConfiguration)instanceContext.getModeConfiguration());
        this.discoveryTypes = DatabaseDiscoveryRule.getDiscoveryProviderAlgorithms(ruleConfig.getDiscoveryTypes());
        this.dataSourceRules = this.getDataSourceRules(ruleConfig.getDataSources(), ruleConfig.getDiscoveryHeartbeats());
        this.findPrimaryReplicaRelationship(databaseName, dataSourceMap);
        this.initHeartBeatJobs();
    }

    public DatabaseDiscoveryRule(String databaseName, Map<String, DataSource> dataSourceMap, AlgorithmProvidedDatabaseDiscoveryRuleConfiguration ruleConfig, InstanceContext instanceContext) {
        this.configuration = ruleConfig;
        this.databaseName = databaseName;
        this.dataSourceMap = dataSourceMap;
        this.instanceContext = instanceContext;
        this.scheduleContext = ScheduleContextFactory.newInstance((ModeConfiguration)instanceContext.getModeConfiguration());
        this.discoveryTypes = ruleConfig.getDiscoveryTypes();
        this.dataSourceRules = this.getDataSourceRules(ruleConfig.getDataSources(), ruleConfig.getDiscoveryHeartbeats());
        this.findPrimaryReplicaRelationship(databaseName, dataSourceMap);
        this.initHeartBeatJobs();
    }

    private static Map<String, DatabaseDiscoveryProviderAlgorithm> getDiscoveryProviderAlgorithms(Map<String, AlgorithmConfiguration> discoveryTypesConfig) {
        LinkedHashMap<String, DatabaseDiscoveryProviderAlgorithm> result = new LinkedHashMap<String, DatabaseDiscoveryProviderAlgorithm>(discoveryTypesConfig.size(), 1.0f);
        for (Map.Entry<String, AlgorithmConfiguration> entry : discoveryTypesConfig.entrySet()) {
            result.put(entry.getKey(), DatabaseDiscoveryProviderAlgorithmFactory.newInstance((AlgorithmConfiguration)entry.getValue()));
        }
        return result;
    }

    private Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources, Map<String, DatabaseDiscoveryHeartBeatConfiguration> heartbeatConfig) {
        HashMap<String, DatabaseDiscoveryDataSourceRule> result = new HashMap<String, DatabaseDiscoveryDataSourceRule>(dataSources.size(), 1.0f);
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : dataSources) {
            result.put(each.getGroupName(), new DatabaseDiscoveryDataSourceRule(each, Strings.isNullOrEmpty((String)each.getDiscoveryHeartbeatName()) ? new Properties() : heartbeatConfig.get(each.getDiscoveryHeartbeatName()).getProps(), this.discoveryTypes.get(each.getDiscoveryTypeName())));
        }
        return result;
    }

    private void findPrimaryReplicaRelationship(String databaseName, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            String groupName = entry.getKey();
            DatabaseDiscoveryDataSourceRule dataSourceRule = entry.getValue();
            Map<String, DataSource> originalDataSourceMap = dataSourceRule.getDataSourceGroup(dataSourceMap);
            DatabaseDiscoveryEngine engine = new DatabaseDiscoveryEngine(dataSourceRule.getDatabaseDiscoveryProviderAlgorithm(), this.instanceContext.getEventBusContext());
            engine.checkEnvironment(databaseName, originalDataSourceMap);
            dataSourceRule.changePrimaryDataSourceName(engine.changePrimaryDataSource(databaseName, groupName, entry.getValue().getPrimaryDataSourceName(), originalDataSourceMap, dataSourceRule.getDisabledDataSourceNames()));
        }
    }

    public DatabaseDiscoveryDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<DatabaseDiscoveryDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void restartHeartBeatJob(DataSourceStatusChangedEvent event) {
        PrimaryDataSourceChangedEvent dataSourceEvent = (PrimaryDataSourceChangedEvent)event;
        QualifiedDatabase qualifiedDatabase = dataSourceEvent.getQualifiedDatabase();
        DatabaseDiscoveryDataSourceRule dataSourceRule = this.dataSourceRules.get(qualifiedDatabase.getGroupName());
        Preconditions.checkNotNull((Object)dataSourceRule, (String)"Can not find database discovery data source rule in database `%s`", (Object)this.databaseName);
        dataSourceRule.changePrimaryDataSourceName(qualifiedDatabase.getDataSourceName());
        this.initHeartBeatJobs();
    }

    public void closeHeartBeatJob() {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            DatabaseDiscoveryDataSourceRule rule = entry.getValue();
            this.scheduleContext.closeSchedule(rule.getDatabaseDiscoveryProviderAlgorithm().getType() + "-" + this.databaseName + "-" + rule.getGroupName());
        }
    }

    private void initHeartBeatJobs() {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            DatabaseDiscoveryDataSourceRule rule = entry.getValue();
            String jobName = rule.getDatabaseDiscoveryProviderAlgorithm().getType() + "-" + this.databaseName + "-" + rule.getGroupName();
            CronJob job = new CronJob(jobName, each -> new HeartbeatJob(this.databaseName, rule.getGroupName(), rule.getPrimaryDataSourceName(), rule.getDataSourceGroup(this.dataSourceMap), rule.getDatabaseDiscoveryProviderAlgorithm(), rule.getDisabledDataSourceNames(), this.instanceContext.getEventBusContext()).execute(null), rule.getHeartbeatProps().getProperty("keep-alive-cron"));
            this.scheduleContext.startSchedule(job);
        }
    }

    public String getPrimaryDataSourceName(String dataSourceName) {
        return this.dataSourceRules.get(dataSourceName).getPrimaryDataSourceName();
    }

    public Collection<String> getReplicaDataSourceNames(String dataSourceName) {
        return this.dataSourceRules.get(dataSourceName).getReplicaDataSourceNames();
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        StorageNodeDataSourceChangedEvent dataSourceChangedEvent = (StorageNodeDataSourceChangedEvent)event;
        DatabaseDiscoveryDataSourceRule dataSourceRule = this.dataSourceRules.get(dataSourceChangedEvent.getQualifiedDatabase().getGroupName());
        Preconditions.checkNotNull((Object)dataSourceRule, (String)"Can not find database discovery data source rule in database `%s`", (Object)this.databaseName);
        if (StorageNodeStatus.isDisable((String)dataSourceChangedEvent.getDataSource().getStatus())) {
            dataSourceRule.disableDataSource(dataSourceChangedEvent.getQualifiedDatabase().getDataSourceName());
        } else {
            dataSourceRule.enableDataSource(dataSourceChangedEvent.getQualifiedDatabase().getDataSourceName());
        }
    }

    public Map<String, Object> getExportData() {
        return Collections.singletonMap("primary_data_source", this.exportPrimaryDataSourceMap());
    }

    private Map<String, String> exportPrimaryDataSourceMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        this.dataSourceRules.forEach((name, dataSourceRule) -> result.put(dataSourceRule.getGroupName(), dataSourceRule.getPrimaryDataSourceName()));
        return result;
    }

    public String getType() {
        return DatabaseDiscoveryRule.class.getSimpleName();
    }

    @Generated
    public RuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules() {
        return this.dataSourceRules;
    }
}

