/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;

public final class DatabaseDiscoveryDataSourceRule {
    private final String groupName;
    private final List<String> dataSourceNames;
    private final Properties heartbeatProps;
    private final DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();
    private volatile String primaryDataSourceName;

    public DatabaseDiscoveryDataSourceRule(DatabaseDiscoveryDataSourceRuleConfiguration config, Properties props, DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm) {
        this.checkConfiguration(config);
        this.groupName = config.getGroupName();
        this.dataSourceNames = config.getDataSourceNames();
        this.heartbeatProps = props;
        this.databaseDiscoveryProviderAlgorithm = databaseDiscoveryProviderAlgorithm;
    }

    private void checkConfiguration(DatabaseDiscoveryDataSourceRuleConfiguration config) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getGroupName()) ? 1 : 0) != 0, (Object)"Group name is required.");
        Preconditions.checkArgument((null != config.getDataSourceNames() && !config.getDataSourceNames().isEmpty() ? 1 : 0) != 0, (Object)"Data source names are required.");
    }

    public List<String> getReplicaDataSourceNames() {
        return this.dataSourceNames.stream().filter(each -> !this.disabledDataSourceNames.contains(each) && !this.primaryDataSourceName.equals(each)).collect(Collectors.toList());
    }

    public void disableDataSource(String dataSourceName) {
        this.disabledDataSourceNames.add(dataSourceName);
    }

    public void enableDataSource(String dataSourceName) {
        this.disabledDataSourceNames.remove(dataSourceName);
    }

    public void changePrimaryDataSourceName(String primaryDataSourceName) {
        this.primaryDataSourceName = primaryDataSourceName;
    }

    public Map<String, DataSource> getDataSourceGroup(Map<String, DataSource> dataSourceMap) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (!this.dataSourceNames.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(this.dataSourceNames.size(), 1.0f);
        for (String each : this.dataSourceNames) {
            result.put(this.groupName, Collections.singletonList(each));
        }
        return result;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public List<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Properties getHeartbeatProps() {
        return this.heartbeatProps;
    }

    @Generated
    public DatabaseDiscoveryProviderAlgorithm getDatabaseDiscoveryProviderAlgorithm() {
        return this.databaseDiscoveryProviderAlgorithm;
    }

    @Generated
    public Collection<String> getDisabledDataSourceNames() {
        return this.disabledDataSourceNames;
    }

    @Generated
    public String getPrimaryDataSourceName() {
        return this.primaryDataSourceName;
    }
}

