/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.route;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.dbdiscovery.route.impl.DatabaseDiscoveryDataSourceRouter;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryDataSourceRule;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryRule;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class DatabaseDiscoverySQLRouter
implements SQLRouter<DatabaseDiscoveryRule> {
    public RouteContext createRouteContext(QueryContext queryContext, ShardingSphereDatabase database, DatabaseDiscoveryRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
        RouteContext result = new RouteContext();
        DatabaseDiscoveryDataSourceRule singleDataSourceRule = rule.getSingleDataSourceRule();
        String dataSourceName = new DatabaseDiscoveryDataSourceRouter(singleDataSourceRule).route();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(singleDataSourceRule.getGroupName(), dataSourceName), Collections.emptyList()));
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, DatabaseDiscoveryRule rule, ConfigurationProperties props, ConnectionContext connectionContext) {
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String dataSourceName = each.getDataSourceMapper().getLogicName();
            Optional<DatabaseDiscoveryDataSourceRule> dataSourceRule = rule.findDataSourceRule(dataSourceName);
            if (!dataSourceRule.isPresent() || !dataSourceRule.get().getGroupName().equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            toBeRemoved.add(each);
            String actualDataSourceName = new DatabaseDiscoveryDataSourceRouter(dataSourceRule.get()).route();
            toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), actualDataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteUnits().addAll(toBeAdded);
    }

    public int getOrder() {
        return 40;
    }

    public Class<DatabaseDiscoveryRule> getTypeClass() {
        return DatabaseDiscoveryRule.class;
    }
}

