/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.algorithm;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.mysql.type.MySQLNormalReplicationDatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spi.ReplicaDataSourceStatus;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceDisabledEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseDiscoveryEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseDiscoveryEngine.class);
    private final DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm;
    private final EventBusContext eventBusContext;

    public void checkEnvironment(String databaseName, Map<String, DataSource> dataSourceMap) {
        this.databaseDiscoveryProviderAlgorithm.checkEnvironment(databaseName, dataSourceMap.values());
    }

    public String changePrimaryDataSource(String databaseName, String groupName, String originalPrimaryDataSourceName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        Optional<String> newPrimaryDataSourceName = this.findPrimaryDataSourceName(dataSourceMap, disabledDataSourceNames);
        if (newPrimaryDataSourceName.isPresent() && !newPrimaryDataSourceName.get().equals(originalPrimaryDataSourceName)) {
            this.eventBusContext.post((Object)new PrimaryDataSourceChangedEvent(new QualifiedDatabase(databaseName, groupName, newPrimaryDataSourceName.get())));
        }
        String result = newPrimaryDataSourceName.orElse(originalPrimaryDataSourceName);
        this.postReplicaDataSourceDisabledEvent(databaseName, groupName, result, dataSourceMap, disabledDataSourceNames);
        return result;
    }

    private Optional<String> findPrimaryDataSourceName(Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            try {
                if (!this.databaseDiscoveryProviderAlgorithm.isPrimaryInstance(entry.getValue())) continue;
                return Optional.of(entry.getKey());
            }
            catch (SQLException ex) {
                log.error("An exception occurred while judge primary data source: ", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private void postReplicaDataSourceDisabledEvent(String databaseName, String groupName, String primaryDataSourceName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        int enabledReplicasCount = dataSourceMap.size() - disabledDataSourceNames.size() - 1;
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getKey().equals(primaryDataSourceName)) continue;
            StorageNodeDataSource storageNodeDataSource = this.createStorageNodeDataSource(this.loadReplicaStatus(entry.getValue()));
            if (StorageNodeStatus.isEnable((String)storageNodeDataSource.getStatus())) {
                enabledReplicasCount += disabledDataSourceNames.contains(entry.getKey()) ? 1 : 0;
                this.eventBusContext.post((Object)new DataSourceDisabledEvent(databaseName, groupName, entry.getKey(), storageNodeDataSource));
                continue;
            }
            if (this.databaseDiscoveryProviderAlgorithm instanceof MySQLNormalReplicationDatabaseDiscoveryProviderAlgorithm && enabledReplicasCount <= Integer.parseInt(this.databaseDiscoveryProviderAlgorithm.getProps().getProperty("min-enabled-replicas", "0"))) continue;
            enabledReplicasCount -= disabledDataSourceNames.contains(entry.getKey()) ? 0 : 1;
            this.eventBusContext.post((Object)new DataSourceDisabledEvent(databaseName, groupName, entry.getKey(), storageNodeDataSource));
        }
    }

    private StorageNodeDataSource createStorageNodeDataSource(ReplicaDataSourceStatus replicaStatus) {
        return new StorageNodeDataSource(StorageNodeRole.MEMBER, replicaStatus.isOnline() ? StorageNodeStatus.ENABLED : StorageNodeStatus.DISABLED, replicaStatus.getReplicationDelayMilliseconds());
    }

    private ReplicaDataSourceStatus loadReplicaStatus(DataSource replicaDataSource) {
        try {
            return this.databaseDiscoveryProviderAlgorithm.loadReplicaStatus(replicaDataSource);
        }
        catch (SQLException ex) {
            log.error("Load data source replica status error: ", (Throwable)ex);
            return new ReplicaDataSourceStatus(false, 0L);
        }
    }

    @Generated
    public DatabaseDiscoveryEngine(DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm, EventBusContext eventBusContext) {
        this.databaseDiscoveryProviderAlgorithm = databaseDiscoveryProviderAlgorithm;
        this.eventBusContext = eventBusContext;
    }
}

