/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.groupby;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.shardingsphere.core.merge.dql.common.MemoryQueryResultRow;
import org.apache.shardingsphere.core.merge.dql.orderby.CompareUtil;
import org.apache.shardingsphere.core.preprocessor.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;

public final class GroupByRowComparator
implements Comparator<MemoryQueryResultRow> {
    private final SelectSQLStatementContext selectSQLStatementContext;
    private final List<Boolean> valueCaseSensitive;

    @Override
    public int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2) {
        if (!this.selectSQLStatementContext.getOrderByContext().getItems().isEmpty()) {
            return this.compare(o1, o2, this.selectSQLStatementContext.getOrderByContext().getItems());
        }
        return this.compare(o1, o2, this.selectSQLStatementContext.getGroupByContext().getItems());
    }

    private int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Object orderValue1 = o1.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue1 || orderValue1 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            Object orderValue2 = o2.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue2 || orderValue2 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            int result = CompareUtil.compareTo((Comparable)orderValue1, (Comparable)orderValue2, each.getSegment().getOrderDirection(), each.getSegment().getNullOrderDirection(), this.valueCaseSensitive.get(each.getIndex()));
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @ConstructorProperties(value={"selectSQLStatementContext", "valueCaseSensitive"})
    public GroupByRowComparator(SelectSQLStatementContext selectSQLStatementContext, List<Boolean> valueCaseSensitive) {
        this.selectSQLStatementContext = selectSQLStatementContext;
        this.valueCaseSensitive = valueCaseSensitive;
    }
}

