/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dal.desc;

import com.google.common.base.Optional;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.dql.common.MemoryMergedResult;
import org.apache.shardingsphere.core.merge.dql.common.MemoryQueryResultRow;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.strategy.encrypt.EncryptTable;

public final class DescribeTableMergedResult
extends MemoryMergedResult {
    private static final Map<String, Integer> LABEL_AND_INDEX_MAP = new HashMap<String, Integer>(6, 1.0f);
    private final ShardingRule shardingRule;
    private final SQLStatementContext sqlStatementContext;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;

    public DescribeTableMergedResult(ShardingRule shardingRule, List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        super(LABEL_AND_INDEX_MAP);
        this.shardingRule = shardingRule;
        this.sqlStatementContext = sqlStatementContext;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                Optional<MemoryQueryResultRow> memoryQueryResultRow = this.optimize(each);
                if (!memoryQueryResultRow.isPresent()) continue;
                result.add(memoryQueryResultRow.get());
            }
        }
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow((MemoryQueryResultRow)result.get(0));
        }
        return result.iterator();
    }

    private Optional<MemoryQueryResultRow> optimize(QueryResult queryResult) throws SQLException {
        MemoryQueryResultRow memoryQueryResultRow = new MemoryQueryResultRow(queryResult);
        String logicTableName = this.sqlStatementContext.getTablesContext().getSingleTableName();
        Optional encryptTable = this.shardingRule.getEncryptRule().findEncryptTable(logicTableName);
        if (encryptTable.isPresent()) {
            String columnName = memoryQueryResultRow.getCell(1).toString();
            if (((EncryptTable)encryptTable.get()).getAssistedQueryColumns().contains(columnName)) {
                return Optional.absent();
            }
            if (((EncryptTable)encryptTable.get()).getCipherColumns().contains(columnName)) {
                memoryQueryResultRow.setCell(1, ((EncryptTable)encryptTable.get()).getLogicColumn(columnName));
            }
        }
        return Optional.of((Object)memoryQueryResultRow);
    }

    @Override
    public boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }

    static {
        LABEL_AND_INDEX_MAP.put("Field", 1);
        LABEL_AND_INDEX_MAP.put("Type", 2);
        LABEL_AND_INDEX_MAP.put("Null", 3);
        LABEL_AND_INDEX_MAP.put("Key", 4);
        LABEL_AND_INDEX_MAP.put("Default", 5);
        LABEL_AND_INDEX_MAP.put("Extra", 6);
    }
}

