/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.request;

import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.server.request.TgtTicketIssuer;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.LastReq;
import org.apache.kerby.kerberos.kerb.type.base.LastReqEntry;
import org.apache.kerby.kerberos.kerb.type.base.LastReqType;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.AsRep;
import org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsRequest
extends KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(AsRequest.class);

    public AsRequest(AsReq asReq, KdcContext kdcContext) {
        super((KdcReq)asReq, kdcContext);
    }

    @Override
    protected void checkClient() throws KrbException {
        KrbIdentity clientEntry;
        PrincipalName clientPrincipal;
        KdcReq request = this.getKdcReq();
        if (this.isToken()) {
            LOG.info("The request is with token.");
            clientPrincipal = new PrincipalName(this.getToken().getSubject());
        } else {
            clientPrincipal = request.getReqBody().getCname();
        }
        if (clientPrincipal == null) {
            LOG.warn("Client principal name is null.");
            throw new KrbException(KrbErrorCode.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        String clientRealm = request.getReqBody().getRealm();
        if (clientRealm == null || clientRealm.isEmpty()) {
            clientRealm = this.getKdcContext().getKdcRealm();
        }
        clientPrincipal.setRealm(clientRealm);
        if (this.isToken()) {
            clientEntry = new KrbIdentity(clientPrincipal.getName());
            clientEntry.setExpireTime(new KerberosTime(this.getToken().getExpiredTime().getTime()));
        } else {
            clientEntry = this.getEntry(clientPrincipal.getName());
        }
        if (this.isAnonymous()) {
            clientEntry.setPrincipal(new PrincipalName(clientPrincipal.getName(), NameType.NT_WELLKNOWN));
        }
        if (clientEntry == null) {
            LOG.warn("Can't get the client entry.");
            throw new KrbException(KrbErrorCode.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        this.setClientEntry(clientEntry);
        for (EncryptionType encType : request.getReqBody().getEtypes()) {
            if (!clientEntry.getKeys().containsKey(encType)) continue;
            EncryptionKey clientKey = (EncryptionKey)clientEntry.getKeys().get(encType);
            this.setClientKey(clientKey);
            break;
        }
    }

    @Override
    protected void issueTicket() throws KrbException {
        TgtTicketIssuer issuer = new TgtTicketIssuer(this);
        Ticket newTicket = issuer.issueTicket();
        this.setTicket(newTicket);
    }

    @Override
    protected void makeReply() throws KrbException {
        Ticket ticket = this.getTicket();
        AsRep reply = new AsRep();
        reply.setTicket(ticket);
        reply.setCname(this.getClientEntry().getPrincipal());
        reply.setCrealm(this.getKdcContext().getKdcRealm());
        EncKdcRepPart encKdcRepPart = this.makeEncKdcRepPart();
        reply.setEncPart(encKdcRepPart);
        EncryptionKey clientKey = this.getClientKey();
        EncryptedData encryptedData = EncryptionUtil.seal((Asn1Encodeable)encKdcRepPart, (EncryptionKey)clientKey, (KeyUsage)KeyUsage.AS_REP_ENCPART);
        reply.setEncryptedEncPart(encryptedData);
        if (this.isPkinit()) {
            reply.setPaData(this.getPreauthContext().getOutputPaData());
        }
        this.setReply((KdcRep)reply);
    }

    protected EncKdcRepPart makeEncKdcRepPart() {
        KdcReq request = this.getKdcReq();
        Ticket ticket = this.getTicket();
        EncAsRepPart encKdcRepPart = new EncAsRepPart();
        encKdcRepPart.setKey(ticket.getEncPart().getKey());
        LastReq lastReq = new LastReq();
        LastReqEntry entry = new LastReqEntry();
        entry.setLrType(LastReqType.THE_LAST_INITIAL);
        entry.setLrValue(new KerberosTime());
        lastReq.add((Asn1Type)entry);
        encKdcRepPart.setLastReq(lastReq);
        encKdcRepPart.setNonce(request.getReqBody().getNonce());
        encKdcRepPart.setFlags(ticket.getEncPart().getFlags());
        encKdcRepPart.setAuthTime(ticket.getEncPart().getAuthTime());
        encKdcRepPart.setStartTime(ticket.getEncPart().getStartTime());
        encKdcRepPart.setEndTime(ticket.getEncPart().getEndTime());
        if (ticket.getEncPart().getFlags().isFlagSet((EnumType)TicketFlag.RENEWABLE)) {
            encKdcRepPart.setRenewTill(ticket.getEncPart().getRenewtill());
        }
        encKdcRepPart.setSname(ticket.getSname());
        encKdcRepPart.setSrealm(ticket.getRealm());
        encKdcRepPart.setCaddr(ticket.getEncPart().getClientAddresses());
        return encKdcRepPart;
    }
}

