/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.base;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.base.TokenFormat;

public class KrbToken
extends KrbSequenceType
implements AuthToken {
    private static TokenEncoder tokenEncoder;
    private static TokenDecoder tokenDecoder;
    private AuthToken innerToken = null;
    static Asn1FieldInfo[] fieldInfos;

    public KrbToken() {
        super(fieldInfos);
    }

    public KrbToken(AuthToken authToken, TokenFormat format) {
        this();
        this.innerToken = authToken;
        this.setTokenType();
        this.setTokenFormat(format);
        try {
            this.setTokenValue(KrbToken.getTokenEncoder().encodeAsBytes(this.innerToken));
        }
        catch (KrbException e) {
            throw new RuntimeException("Failed to encode AuthToken", e);
        }
    }

    public AuthToken getAuthToken() {
        return this.innerToken;
    }

    public void setTokenType() {
        List<String> audiences = this.innerToken.getAudiences();
        if (audiences.size() == 1 && audiences.get(0).startsWith("krbtgt")) {
            this.isIdToken(true);
        } else {
            this.isAcToken(true);
        }
    }

    protected static TokenEncoder getTokenEncoder() {
        if (tokenEncoder == null) {
            tokenEncoder = KrbRuntime.getTokenProvider().createTokenEncoder();
        }
        return tokenEncoder;
    }

    protected static TokenDecoder getTokenDecoder() {
        if (tokenDecoder == null) {
            tokenDecoder = KrbRuntime.getTokenProvider().createTokenDecoder();
        }
        return tokenDecoder;
    }

    public TokenFormat getTokenFormat() {
        Integer value = this.getFieldAsInteger(KrbTokenField.TOKEN_FORMAT);
        return TokenFormat.fromValue(value);
    }

    public void setTokenFormat(TokenFormat tokenFormat) {
        this.setFieldAsInt(KrbTokenField.TOKEN_FORMAT, tokenFormat.getValue());
    }

    public byte[] getTokenValue() {
        return this.getFieldAsOctets(KrbTokenField.TOKEN_VALUE);
    }

    public void setTokenValue(byte[] tokenValue) {
        this.setFieldAsOctets(KrbTokenField.TOKEN_VALUE, tokenValue);
    }

    @Override
    public String getSubject() {
        return this.innerToken.getSubject();
    }

    @Override
    public void setSubject(String sub) {
        this.innerToken.setSubject(sub);
    }

    @Override
    public String getIssuer() {
        return this.innerToken.getIssuer();
    }

    @Override
    public void setIssuer(String issuer) {
        this.innerToken.setIssuer(issuer);
    }

    @Override
    public List<String> getAudiences() {
        return this.innerToken.getAudiences();
    }

    @Override
    public void setAudiences(List<String> audiences) {
        this.innerToken.setAudiences(audiences);
    }

    @Override
    public boolean isIdToken() {
        return this.innerToken.isIdToken();
    }

    @Override
    public void isIdToken(boolean isIdToken) {
        this.innerToken.isIdToken(isIdToken);
    }

    @Override
    public boolean isAcToken() {
        return this.innerToken.isAcToken();
    }

    @Override
    public void isAcToken(boolean isAcToken) {
        this.innerToken.isAcToken(isAcToken);
    }

    @Override
    public boolean isBearerToken() {
        return this.innerToken.isBearerToken();
    }

    @Override
    public boolean isHolderOfKeyToken() {
        return this.innerToken.isHolderOfKeyToken();
    }

    @Override
    public Date getExpiredTime() {
        return this.innerToken.getExpiredTime();
    }

    @Override
    public void setExpirationTime(Date exp) {
        this.innerToken.setExpirationTime(exp);
    }

    @Override
    public Date getNotBeforeTime() {
        return this.innerToken.getNotBeforeTime();
    }

    @Override
    public void setNotBeforeTime(Date nbt) {
        this.innerToken.setNotBeforeTime(nbt);
    }

    @Override
    public Date getIssueTime() {
        return this.innerToken.getIssueTime();
    }

    @Override
    public void setIssueTime(Date iat) {
        this.innerToken.setIssueTime(iat);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.innerToken.getAttributes();
    }

    @Override
    public void addAttribute(String name, Object value) {
        this.innerToken.addAttribute(name, value);
    }

    public void setInnerToken(AuthToken authToken) {
        this.innerToken = authToken;
    }

    static {
        fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)KrbTokenField.TOKEN_FORMAT, Asn1Integer.class), new ExplicitField((EnumType)KrbTokenField.TOKEN_VALUE, Asn1OctetString.class)};
    }

    protected static enum KrbTokenField implements EnumType
    {
        TOKEN_FORMAT,
        TOKEN_VALUE;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

