/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import javax.sql.DataSource;
import org.apache.ibatis.transaction.TransactionFactory;

public class Environment {
    private String id;
    private TransactionFactory transactionFactory;
    private DataSource dataSource;

    public Environment(String id, TransactionFactory transactionFactory, DataSource dataSource) {
        this.id = id;
        this.transactionFactory = transactionFactory;
        this.dataSource = dataSource;
    }

    private Environment() {
    }

    public String getId() {
        return this.id;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static class Builder {
        private Environment environment = new Environment();

        public Builder(String id, TransactionFactory transactionManager, DataSource dataSource) {
            this.environment.id = id;
            this.environment.transactionFactory = transactionManager;
            this.environment.dataSource = dataSource;
        }

        public Builder transactionFactory(TransactionFactory transactionFactory) {
            this.environment.transactionFactory = transactionFactory;
            return this;
        }

        public Builder dataSource(DataSource dataSource) {
            this.environment.dataSource = dataSource;
            return this;
        }

        public String id() {
            return this.environment.id;
        }

        public Environment build() {
            return this.environment;
        }
    }
}

