/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBuilder {
    private static final String AND = ") \nAND (";
    private static final String OR = ") \nOR (";
    private static final ThreadLocal<SelectSQL> localSQL = new ThreadLocal();

    public static void BEGIN() {
        SelectBuilder.RESET();
    }

    public static void RESET() {
        localSQL.set(new SelectSQL());
    }

    public static void SELECT(String columns) {
        SelectBuilder.sql().select.add(columns);
    }

    public static void FROM(String table) {
        SelectBuilder.sql().from.add(table);
    }

    public static void JOIN(String join) {
        SelectBuilder.sql().join.add(join);
    }

    public static void INNER_JOIN(String join) {
        SelectBuilder.sql().innerJoin.add(join);
    }

    public static void LEFT_OUTER_JOIN(String join) {
        SelectBuilder.sql().leftOuterJoin.add(join);
    }

    public static void RIGHT_OUTER_JOIN(String join) {
        SelectBuilder.sql().rightOuterJoin.add(join);
    }

    public static void OUTER_JOIN(String join) {
        SelectBuilder.sql().outerJoin.add(join);
    }

    public static void WHERE(String conditions) {
        SelectBuilder.sql().where.add(conditions);
        SelectBuilder.sql().lastList = SelectBuilder.sql().where;
    }

    public static void OR() {
        SelectBuilder.sql().lastList.add(OR);
    }

    public static void AND() {
        SelectBuilder.sql().lastList.add(AND);
    }

    public static void GROUP_BY(String columns) {
        SelectBuilder.sql().groupBy.add(columns);
    }

    public static void HAVING(String conditions) {
        SelectBuilder.sql().having.add(conditions);
        SelectBuilder.sql().lastList = SelectBuilder.sql().having;
    }

    public static void ORDER_BY(String columns) {
        SelectBuilder.sql().orderBy.add(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String SQL() {
        try {
            StringBuilder builder = new StringBuilder();
            SelectBuilder.selectClause(builder, "SELECT", SelectBuilder.sql().select, "", "", ", ");
            SelectBuilder.selectClause(builder, "FROM", SelectBuilder.sql().from, "", "", ", ");
            SelectBuilder.selectClause(builder, "JOIN", SelectBuilder.sql().join, "", "", "JOIN");
            SelectBuilder.selectClause(builder, "INNER JOIN", SelectBuilder.sql().innerJoin, "", "", "\nINNER JOIN ");
            SelectBuilder.selectClause(builder, "OUTER JOIN", SelectBuilder.sql().outerJoin, "", "", "\nOUTER JOIN ");
            SelectBuilder.selectClause(builder, "LEFT OUTER JOIN", SelectBuilder.sql().leftOuterJoin, "", "", "\nLEFT OUTER JOIN ");
            SelectBuilder.selectClause(builder, "RIGHT OUTER JOIN", SelectBuilder.sql().rightOuterJoin, "", "", "\nRIGHT OUTER JOIN ");
            SelectBuilder.selectClause(builder, "WHERE", SelectBuilder.sql().where, "(", ")", " AND ");
            SelectBuilder.selectClause(builder, "GROUP BY", SelectBuilder.sql().groupBy, "", "", ", ");
            SelectBuilder.selectClause(builder, "HAVING", SelectBuilder.sql().having, "(", ")", " AND ");
            SelectBuilder.selectClause(builder, "ORDER BY", SelectBuilder.sql().orderBy, "", "", ", ");
            String string = builder.toString();
            return string;
        }
        finally {
            SelectBuilder.RESET();
        }
    }

    private static void selectClause(StringBuilder builder, String keyword, List<String> parts, String open, String close, String conjunction) {
        if (!parts.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(keyword);
            builder.append(" ");
            builder.append(open);
            String last = "________";
            int n = parts.size();
            for (int i = 0; i < n; ++i) {
                String part = parts.get(i);
                if (!(i <= 0 || part.equals(AND) || part.equals(OR) || last.equals(AND) || last.equals(OR))) {
                    builder.append(conjunction);
                }
                builder.append(part);
                last = part;
            }
            builder.append(close);
        }
    }

    private static SelectSQL sql() {
        SelectSQL selectSQL = localSQL.get();
        if (selectSQL == null) {
            SelectBuilder.RESET();
            selectSQL = localSQL.get();
        }
        return selectSQL;
    }

    private static class SelectSQL {
        List<String> select = new ArrayList<String>();
        List<String> from = new ArrayList<String>();
        List<String> join = new ArrayList<String>();
        List<String> innerJoin = new ArrayList<String>();
        List<String> outerJoin = new ArrayList<String>();
        List<String> leftOuterJoin = new ArrayList<String>();
        List<String> rightOuterJoin = new ArrayList<String>();
        List<String> where = new ArrayList<String>();
        List<String> having = new ArrayList<String>();
        List<String> groupBy = new ArrayList<String>();
        List<String> orderBy = new ArrayList<String>();
        List<String> lastList = new ArrayList<String>();

        private SelectSQL() {
        }
    }
}

