/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZKAssign {
    private static final Log LOG = LogFactory.getLog(ZKAssign.class);

    public static String getNodeName(ZooKeeperWatcher zkw, String regionName) {
        return ZKUtil.joinZNode(zkw.assignmentZNode, regionName);
    }

    public static String getRegionName(ZooKeeperWatcher zkw, String path) {
        return path.substring(zkw.assignmentZNode.length() + 1);
    }

    public static void createNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, KeeperException.NodeExistsException {
        ZKAssign.createNodeOffline(zkw, region, serverName, EventHandler.EventType.M_ZK_REGION_OFFLINE);
    }

    public static void createNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventHandler.EventType event) throws KeeperException, KeeperException.NodeExistsException {
        LOG.debug((Object)zkw.prefix("Creating unassigned node for " + region.getEncodedName() + " in OFFLINE state"));
        RegionTransitionData data = new RegionTransitionData(event, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        ZKUtil.createAndWatch(zkw, node, data.getBytes());
    }

    public static void asyncCreateNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, AsyncCallback.StringCallback cb, Object ctx) throws KeeperException {
        LOG.debug((Object)zkw.prefix("Async create of unassigned node for " + region.getEncodedName() + " with OFFLINE state"));
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_OFFLINE, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        ZKUtil.asyncCreate(zkw, node, data.getBytes(), cb, ctx);
    }

    public static void forceNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, KeeperException.NoNodeException {
        LOG.debug((Object)zkw.prefix("Forcing existing unassigned node for " + region.getEncodedName() + " to OFFLINE state"));
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_OFFLINE, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        ZKUtil.setData(zkw, node, data.getBytes());
    }

    public static int createOrForceNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException {
        return ZKAssign.createOrForceNodeOffline(zkw, region, serverName, false, true);
    }

    public static int createOrForceNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, boolean hijack, boolean allowCreation) throws KeeperException {
        EventHandler.EventType eventType;
        LOG.debug((Object)zkw.prefix("Creating (or updating) unassigned node for " + region.getEncodedName() + " with OFFLINE state"));
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_OFFLINE, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        Stat stat = new Stat();
        zkw.sync(node);
        int version = ZKUtil.checkExists(zkw, node);
        if (version == -1) {
            if (hijack && !allowCreation) {
                return -1;
            }
            return ZKUtil.createAndWatch(zkw, node, data.getBytes());
        }
        RegionTransitionData curDataInZNode = ZKAssign.getDataNoWatch(zkw, region.getEncodedName(), stat);
        if (hijack && null != curDataInZNode && ((eventType = curDataInZNode.getEventType()).equals((Object)EventHandler.EventType.M_ZK_REGION_CLOSING) || eventType.equals((Object)EventHandler.EventType.RS_ZK_REGION_CLOSED) || eventType.equals((Object)EventHandler.EventType.RS_ZK_REGION_OPENED))) {
            return -1;
        }
        boolean setData = false;
        try {
            setData = ZKUtil.setData(zkw, node, data.getBytes(), version);
        }
        catch (KeeperException kpe) {
            LOG.info((Object)"Version mismatch while setting the node to OFFLINE state.");
            return -1;
        }
        if (!setData) {
            return -1;
        }
        RegionTransitionData curData = ZKAssign.getData(zkw, region.getEncodedName());
        if (curData.getEventType() != data.getEventType()) {
            return -1;
        }
        return stat.getVersion() + 1;
    }

    public static boolean deleteOpenedNode(ZooKeeperWatcher zkw, String regionName) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, regionName, EventHandler.EventType.RS_ZK_REGION_OPENED);
    }

    public static boolean deleteOfflineNode(ZooKeeperWatcher zkw, String regionName) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, regionName, EventHandler.EventType.M_ZK_REGION_OFFLINE);
    }

    public static boolean deleteClosedNode(ZooKeeperWatcher zkw, String regionName) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, regionName, EventHandler.EventType.RS_ZK_REGION_CLOSED);
    }

    public static boolean deleteClosingNode(ZooKeeperWatcher zkw, HRegionInfo region) throws KeeperException, KeeperException.NoNodeException {
        String regionName = region.getEncodedName();
        return ZKAssign.deleteNode(zkw, regionName, EventHandler.EventType.M_ZK_REGION_CLOSING);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String regionName, EventHandler.EventType expectedState) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, regionName, expectedState, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String regionName, EventHandler.EventType expectedState, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        LOG.debug((Object)zkw.prefix("Deleting existing unassigned node for " + regionName + " that is in expected state " + (Object)((Object)expectedState)));
        String node = ZKAssign.getNodeName(zkw, regionName);
        zkw.sync(node);
        Stat stat = new Stat();
        byte[] bytes = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (bytes == null) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
        }
        RegionTransitionData data = RegionTransitionData.fromBytes(bytes);
        if (!data.getEventType().equals((Object)expectedState)) {
            LOG.warn((Object)zkw.prefix("Attempting to delete unassigned node " + regionName + " in " + (Object)((Object)expectedState) + " state but node is in " + (Object)((Object)data.getEventType()) + " state"));
            return false;
        }
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn((Object)("The node " + regionName + " we are trying to delete is not" + " the expected one. Got a version mismatch"));
            return false;
        }
        if (!ZKUtil.deleteNode(zkw, node, stat.getVersion())) {
            LOG.warn((Object)zkw.prefix("Attempting to delete unassigned node " + regionName + " in " + (Object)((Object)expectedState) + " state but after verifying state, we got a version mismatch"));
            return false;
        }
        LOG.debug((Object)zkw.prefix("Successfully deleted unassigned node for region " + regionName + " in expected state " + (Object)((Object)expectedState)));
        return true;
    }

    public static void deleteAllNodes(ZooKeeperWatcher zkw) throws KeeperException {
        LOG.debug((Object)zkw.prefix("Deleting any existing unassigned nodes"));
        ZKUtil.deleteChildrenRecursively(zkw, zkw.assignmentZNode);
    }

    public static int createNodeClosing(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, KeeperException.NodeExistsException {
        LOG.debug((Object)zkw.prefix("Creating unassigned node for " + region.getEncodedName() + " in a CLOSING state"));
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.M_ZK_REGION_CLOSING, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        return ZKUtil.createAndWatch(zkw, node, data.getBytes());
    }

    public static int transitionNodeClosed(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, EventHandler.EventType.M_ZK_REGION_CLOSING, EventHandler.EventType.RS_ZK_REGION_CLOSED, expectedVersion);
    }

    public static int transitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException {
        return ZKAssign.transitionNodeOpening(zkw, region, serverName, EventHandler.EventType.M_ZK_REGION_OFFLINE);
    }

    public static int transitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventHandler.EventType beginState) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, beginState, EventHandler.EventType.RS_ZK_REGION_OPENING, -1);
    }

    public static int retransitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, EventHandler.EventType.RS_ZK_REGION_OPENING, EventHandler.EventType.RS_ZK_REGION_OPENING, expectedVersion);
    }

    public static int transitionNodeOpened(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, EventHandler.EventType.RS_ZK_REGION_OPENING, EventHandler.EventType.RS_ZK_REGION_OPENED, expectedVersion);
    }

    public static int transitionNode(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventHandler.EventType beginState, EventHandler.EventType endState, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, beginState, endState, expectedVersion, null);
    }

    public static int transitionNode(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventHandler.EventType beginState, EventHandler.EventType endState, int expectedVersion, byte[] payload) throws KeeperException {
        String encoded = region.getEncodedName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)zkw.prefix("Attempting to transition node " + HRegionInfo.prettyPrint(encoded) + " from " + beginState.toString() + " to " + endState.toString()));
        }
        String node = ZKAssign.getNodeName(zkw, encoded);
        zkw.sync(node);
        Stat stat = new Stat();
        byte[] existingBytes = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (existingBytes == null) {
            return -1;
        }
        RegionTransitionData existingData = RegionTransitionData.fromBytes(existingBytes);
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn((Object)zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return -1;
        }
        if (beginState.equals((Object)EventHandler.EventType.M_ZK_REGION_OFFLINE) && endState.equals((Object)EventHandler.EventType.RS_ZK_REGION_OPENING) && expectedVersion == -1 && stat.getVersion() != 0) {
            LOG.warn((Object)zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return -1;
        }
        if (!existingData.getEventType().equals((Object)beginState)) {
            LOG.warn((Object)zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed but was in the state " + (Object)((Object)existingData.getEventType()) + " set by the server " + serverName));
            return -1;
        }
        try {
            RegionTransitionData data = new RegionTransitionData(endState, region.getRegionName(), serverName, payload);
            if (!ZKUtil.setData(zkw, node, data.getBytes(), stat.getVersion())) {
                LOG.warn((Object)zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed and was in the expected state but then when " + "setting data we got a version mismatch"));
                return -1;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)zkw.prefix("Successfully transitioned node " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState)));
            }
            return stat.getVersion() + 1;
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn((Object)zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed and was in the expected state but then when " + "setting data it no longer existed"));
            return -1;
        }
    }

    public static RegionTransitionData getData(ZooKeeperWatcher zkw, String pathOrRegionName) throws KeeperException {
        String node = pathOrRegionName.startsWith("/") ? pathOrRegionName : ZKAssign.getNodeName(zkw, pathOrRegionName);
        byte[] data = ZKUtil.getDataAndWatch(zkw, node);
        if (data == null) {
            return null;
        }
        return RegionTransitionData.fromBytes(data);
    }

    public static RegionTransitionData getDataAndWatch(ZooKeeperWatcher zkw, String pathOrRegionName, Stat stat) throws KeeperException {
        String node = pathOrRegionName.startsWith("/") ? pathOrRegionName : ZKAssign.getNodeName(zkw, pathOrRegionName);
        byte[] data = ZKUtil.getDataAndWatch(zkw, node, stat);
        if (data == null) {
            return null;
        }
        return RegionTransitionData.fromBytes(data);
    }

    public static RegionTransitionData getDataNoWatch(ZooKeeperWatcher zkw, String pathOrRegionName, Stat stat) throws KeeperException {
        String node = pathOrRegionName.startsWith("/") ? pathOrRegionName : ZKAssign.getNodeName(zkw, pathOrRegionName);
        byte[] data = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (data == null) {
            return null;
        }
        return RegionTransitionData.fromBytes(data);
    }

    public static int getVersion(ZooKeeperWatcher zkw, HRegionInfo region) throws KeeperException {
        String znode = ZKAssign.getNodeName(zkw, region.getEncodedName());
        return ZKUtil.checkExists(zkw, znode);
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher watcher, HRegionInfo regionInfo) throws KeeperException {
        String node = ZKAssign.getNodeName(watcher, regionInfo.getEncodedName());
        ZKUtil.deleteNodeFailSilent(watcher, node);
    }

    public static void blockUntilNoRIT(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        while (ZKUtil.nodeHasChildren(zkw, zkw.assignmentZNode)) {
            List<String> znodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, zkw.assignmentZNode);
            if (znodes != null && !znodes.isEmpty()) {
                for (String znode : znodes) {
                    LOG.debug((Object)("ZK RIT -> " + znode));
                }
            }
            Thread.sleep(100L);
        }
    }

    public static void blockUntilRIT(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        while (!ZKUtil.nodeHasChildren(zkw, zkw.assignmentZNode)) {
            List<String> znodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, zkw.assignmentZNode);
            if (znodes == null || znodes.isEmpty()) {
                LOG.debug((Object)"No RIT in ZK");
            }
            Thread.sleep(100L);
        }
    }

    public static boolean verifyRegionState(ZooKeeperWatcher zkw, HRegionInfo region, EventHandler.EventType expectedState) throws KeeperException {
        String encoded = region.getEncodedName();
        String node = ZKAssign.getNodeName(zkw, encoded);
        zkw.sync(node);
        byte[] existingBytes = null;
        try {
            existingBytes = ZKUtil.getDataAndWatch(zkw, node);
        }
        catch (KeeperException.NoNodeException nne) {
            return false;
        }
        catch (KeeperException e) {
            throw e;
        }
        if (existingBytes == null) {
            return false;
        }
        RegionTransitionData existingData = RegionTransitionData.fromBytes(existingBytes);
        return existingData.getEventType() == expectedState;
    }
}

